﻿---
title: Configure logging for standalone Elastic Agents
description: The Logging section of the elastic-agent.yml config file contains settings for configuring the logging output. The logging system can write logs to the...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-standalone-logging-config
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure logging for standalone Elastic Agents
The Logging section of the `elastic-agent.yml` config file contains settings for configuring the logging output. The logging system can write logs to the `syslog`, `file`, `stderr`, `eventlog`, or rotate log files. If you do not explicitly configure logging, the `stderr` output is used.
This example configures Elastic Agent logging:
```yaml
agent.logging.level: info
agent.logging.to_files: true
agent.logging.files:
  path: /var/log/elastic-agent
  name: elastic-agent
  keepfiles: 7
  permissions: 0600
```


## Logging configuration settings

You can specify the following settings in the Logging section of the `elastic-agent.yml` config file.
Some outputs will log raw events on errors like indexing errors in the Elasticsearch output, to prevent logging raw events (that may contain sensitive information) together with other log messages, a different log file, only for log entries containing raw events, is used. It will use the same level, selectors and all other configurations from the default logger, but it will have its own file configuration.
Having a different log file for raw events also prevents event data from drowning out the regular log files. Use `agent.logging.event_data` to configure the events logger.
The events log file is not collected by the Elastic Agent monitoring. If the events log files are needed, they can be collected with the diagnostics or directly copied from the host running Elastic Agent.

| Setting                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
|---------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `agent.logging.level`                             | The minimum log level.Possible values:• `error`: Logs errors and critical errors.• `warning`: Logs warnings, errors, and critical errors.• `info`: Logs informational messages, including the number of events that are published. Also logs any warnings, errors, or critical errors.• `debug`: Logs debug messages, including a detailed printout of all events flushed. Also logs informational messages, warnings, errors, and critical errors. When the log level is `debug`, you can specify a list of **selectors** to display debug messages for specific components. If no selectors are specified, the `*` selector is used to display debug messages for all components.Default: `info` |
| `agent.logging.selectors`                         | Specify the selector tags that are used by different Elastic Agent components for debugging. To debug the output for all components, use `*`. To display debug messages related to event publishing, set to `publish`. Multiple selectors can be chained.Possible values: `[beat]`, `[publish]`, `[service]`                                                                                                                                                                                                                                                                                                                                                                                       |
| `agent.logging.to_stderr`                         | Set to `true` to write all logging output to the `stderr` output—this is equivalent to using the `-e` command line option.Default: `true`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `agent.logging.to_syslog`                         | Set to `true` to write all logging output to the `syslog` output.Default: `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.logging.to_eventlog`                       | Set to `true` to write all logging output to the Windows `eventlog` output.Default: `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `agent.logging.metrics.enabled`                   | Set to `true` for Elastic Agent to periodically log its internal metrics that have changed in the last period. For each metric that changed, the delta from the value at the beginning of the period is logged. Also, the total values for all non-zero internal metrics get logged on shutdown. If set to `false`, no metrics for the agent or any of the Beats running under it are logged.Default: `true`                                                                                                                                                                                                                                                                                       |
| `agent.logging.metrics.period`                    | Specify the period after which to log the internal metrics. This setting is not passed to any Beats running under the Elastic Agent.Default: `30s`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.logging.to_files`                          | Set to `true` to log to rotating files. Set to `false` to disable logging to files.Default: `true`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.logging.files.path`                        | The directory that log files is written to. Logs file names end with a date and optional number: log-date.ndjson, log-date-1.ndjson, and so on as new files are created during rotation.macOS: `/Library/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson`Linux: `/opt/Elastic/Agent/data/elastic-agent-*/logs/elastic-agent.ndjson`Windows: `C:\Program Files\Elastic\Agent\data\elastic-agent-*\logs\elastic-agent.ndjson`DEB: `/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson`RPM: `/var/lib/elastic-agent/data/elastic-agent-*/logs/elastic-agent.ndjson`                                                                                                   |
| `agent.logging.files.name`                        | The name of the file that logs are written to.Default: `elastic-agent`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| `agent.logging.files.rotateeverybytes`            | The maximum size limit of a log file. If the limit is reached, a new log file is generated.Default: `10485760` (10MB)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `agent.logging.files.keepfiles`                   | The most recent number of rotated log files to keep on disk. Older files are deleted during log rotation. The value must be in the range of `2` to `1024` files.Default: `7`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `agent.logging.files.permissions`                 | The permissions mask to apply when rotating log files. The permissions option must be a valid Unix-style file permissions mask expressed in octal notation. In Go, numbers in octal notation must start with 0.Default: `0600`                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `agent.logging.files.interval`                    | Enable log file rotation on time intervals in addition to the size-based rotation. Intervals must be at least `1s`. Values of `1m`, `1h`, `24h`, `7*24h`, `30*24h`, and `365*24h` are boundary-aligned with minutes, hours, days, weeks, months, and years as reported by the local system clock. All other intervals get calculated from the Unix epoch.Default: `0` (disabled)                                                                                                                                                                                                                                                                                                                   |
| `agent.logging.files.rotateonstartup`             | Set to `true` to rotate existing logs on startup rather than to append to the existing file.Default: `true`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `agent.logging.event_data.to_files`               | Set to `true` to log to rotating files. Set to `false` to disable logging to files.Default: `true`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `agent.logging.event_data.path`                   | The directory that log files is written to. Logs file names end with a date and optional number: log-date.ndjson, log-date-1.ndjson, and so on as new files are created during rotation.macOS: `/Library/Elastic/Agent/data/elastic-agent-*/logs/events/elastic-agent-event-log*.ndjson`Linux: `/opt/Elastic/Agent/data/elastic-agent-*/logs/events/elastic-agent-event-log*.ndjson`Windows: `C:\Program Files\Elastic\Agent\data\elastic-agent-*\logs\events\elastic-agent-event-log*.ndjson`DEB: `/var/lib/elastic-agent/data/elastic-agent-*/logs/events/elastic-agent-event-log*.ndjson`RPM: `/var/lib/elastic-agent/data/elastic-agent-*/logs/events/elastic-agent-event-log*.ndjson`         |
| `agent.logging.event_data.files.name`             | The name of the file that logs are written to.Default: `elastic-agent-event-data`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| `agent.logging.event_data.files.rotateeverybytes` | The maximum size limit of a log file. If the limit is reached, a new log file is generated.Default: `5242880` (5MB)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `agent.logging.event_data.files.keepfiles`        | The most recent number of rotated log files to keep on disk. Older files are deleted during log rotation. The value must be in the range of `2` to `1024` files.Default: `2`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `agent.logging.event_data.files.permissions`      | The permissions mask to apply when rotating log files. The permissions option must be a valid Unix-style file permissions mask expressed in octal notation. In Go, numbers in octal notation must start with 0.Default: `0600`                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| `agent.logging.event_data.files.interval`         | Enable log file rotation on time intervals in addition to the size-based rotation. Intervals must be at least `1s`. Values of `1m`, `1h`, `24h`, `7*24h`, `30*24h`, and `365*24h` are boundary-aligned with minutes, hours, days, weeks, months, and years as reported by the local system clock. All other intervals get calculated from the Unix epoch.Default: `0` (disabled)                                                                                                                                                                                                                                                                                                                   |
| `agent.logging.event_data.files.rotateonstartup`  | Set to `true` to rotate existing logs on startup rather than to append to the existing file.Default: `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |