﻿---
title: Configure feature flags for standalone Elastic Agents
description: The Feature Flags section of the elastic-agent.yml config file contains settings in Elastic Agent that are disabled by default. These may include experimental...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-standalone-feature-flags
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure feature flags for standalone Elastic Agents
The Feature Flags section of the elastic-agent.yml config file contains settings in Elastic Agent that are disabled by default. These may include experimental features, changes to behaviors within Elastic Agent or its components, or settings that could cause a breaking change. For example a setting that changes information included in events might be inconsistent with the naming pattern expected in your configured Elastic Agent output.
To enable any of the settings listed on this page, change the associated `enabled` flag from `false` to `true`.
```yaml
agent.features:
  mysetting:
    enabled: true
```


## Feature flag configuration settings

You can specify the following settings in the Feature Flag section of the `elastic-agent.yml` config file.
<definitions>
  <definition term="Fully qualified domain name (FQDN)">
    When enabled, information provided about the current host through the [host.name](https://www.elastic.co/docs/reference/fleet/host-provider) key, in events produced by Elastic Agent, is in FQDN format (`somehost.example.com` rather than `somehost`). This helps you to distinguish between hosts on different domains that have similar names. With `fqdn` enabled, the fully qualified hostname allows each host to be more easily identified when viewed in Kibana.
    <note>
      FQDN reporting is not currently supported in APM.
    </note>
    For FQDN reporting to work as expected, the hostname of the current host must either:
    - Have a CNAME entry defined in DNS.
    - Have one of its corresponding IP addresses respond successfully to a reverse DNS lookup.
    If neither pre-requisite is satisfied, `host.name` continues to report the hostname of the current host as if the FQDN feature flag were not enabled.
    To enable fully qualified domain names set `enabled: true` for the `fqdn` setting:
    ```yaml
    agent.features:
      fqdn:
        enabled: true
    ```
  </definition>
</definitions>