﻿---
title: Configure download settings for standalone Elastic Agent upgrades
description: The agent.download section of the elastic-agent.yml config file contains settings for where to download and store artifacts used for Elastic Agent upgrades...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-standalone-download
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure download settings for standalone Elastic Agent upgrades
The `agent.download` section of the elastic-agent.yml config file contains settings for where to download and store artifacts used for Elastic Agent upgrades.


| Setting                     | Description                                                                                  |
|-----------------------------|----------------------------------------------------------------------------------------------|
| `sourceURI`                 | (string) Path to the location of artifacts used during Elastic Agent upgrade.                |
| `target_directory`          | (string) Path to the directory where download artifacts are stored.                          |
| `timeout`                   | (string) The HTTP request timeout in seconds for the download package attempt.               |
| `install_path`              | (string) The location of installed packages and programs, as well as program specifications. |
| `retry_sleep_init_duration` | (string) The duration in seconds to sleep for before the first retry attempt.                |