﻿---
title: Simplified log ingestion
description: There is a simplified option for ingesting log files with Elastic Agent. The simplest input configuration to ingest the file /var/log/my-application/log-file.log...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-simplified-input-configuration
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Simplified log ingestion
There is a simplified option for ingesting log files with Elastic Agent. The simplest input configuration to ingest the file `/var/log/my-application/log-file.log` is:
```yaml
inputs:
  - type: filestream 
    id: unique-id-per-input 
    paths: 
      - /var/log/my-application/log-file.log
```

For other custom options to configure the input, refer to the [filestream input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream) in the Filebeat documentation.