﻿---
title: Reference YAML
description: The Elastic Agent installation includes an elastic-agent.reference.yml file that describes all the settings available in a standalone configuration. To...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-reference-yaml
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Reference YAML
The Elastic Agent installation includes an `elastic-agent.reference.yml` file that describes all the settings available in a standalone configuration.
To ensure that you’re accessing the latest version, refer to the original [`elastic-agent.reference.yml` file](https://github.com/elastic/elastic-agent/blob/main/elastic-agent.reference.yml) in the `elastic/elastic-agent` repository. A copy is included here for your convenience.
Each section of the file and available settings are also described in [Structure of a config file](https://www.elastic.co/docs/reference/fleet/structure-config-file).
```yaml
## Agent Configuration Example #########################

# This file is an example configuration file highlighting only the most common
# options. The elastic-agent.reference.yml file from the same directory contains all the
# supported options with more comments. You can use it as a reference.

######################################
# Fleet configuration
######################################
outputs:
  default:
    type: elasticsearch
    hosts: [127.0.0.1:9200]
    api_key: "example-key"
    # username: "elastic"
    # password: "changeme"

    # Performance preset for elasticsearch outputs. One of "balanced", "throughput",
    # "scale", "latency" and "custom".
    # The default if unspecified is "custom".
    preset: balanced

inputs:
  - type: system/metrics
    # Each input must have a unique ID.
    id: unique-system-metrics-input
    # Namespace name must conform to the naming conventions for Elasticsearch indices, cannot contain dashes (-), and cannot exceed 100 bytes
    # For index naming restrictions, see https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create#indices-create-api-path-params
    data_stream.namespace: default
    use_output: default
    streams:
      - metricsets:
        - cpu
        # Dataset name must conform to the naming conventions for Elasticsearch indices, cannot contain dashes (-), and cannot exceed 100 bytes
        data_stream.dataset: system.cpu
      - metricsets:
        - memory
        data_stream.dataset: system.memory
      - metricsets:
        - network
        data_stream.dataset: system.network
      - metricsets:
        - filesystem
        data_stream.dataset: system.filesystem

#   # Collecting log files
#   - type: filestream
#     # Input ID allowing Elastic Agent to track the state of this input. Must be unique.
#     id: your-input-id
#     streams:
#       # Stream ID for this data stream allowing Filebeat to track the state of the ingested files. Must be unique.
#       # Each filestream data stream creates a separate instance of the Filebeat filestream input.
#       - id: your-filestream-stream-id
#         data_stream:
#           dataset: generic
#         paths:
#           - /var/log/*.log

# management:
#   # Mode of management, the Elastic Agent support two modes of operation:
#   #
#   # local: The Elastic Agent will expect to find the inputs configuration in the local file.
#   #
#   # Default is local.
#   mode: "local"

# fleet:
#   access_api_key: ""
#   kibana:
#     # kibana minimal configuration
#     hosts: ["localhost:5601"]
#     ssl.certificate_authorities: ["/etc/pki/root/ca.pem"]

#     # optional values
#     #protocol: "https"
#     #service_token: "example-token"
#     #path: ""
#     #ssl.verification_mode: full
#     #ssl.supported_protocols: [TLSv1.2, TLSv1.3]
#     #ssl.cipher_suites: []
#     #ssl.curve_types: []
#   reporting:
#     # Reporting threshold indicates how many events should be kept in-memory before reporting them to fleet.
#     #reporting_threshold: 10000
#     # Frequency used to check the queue of events to be sent out to fleet.
#     #reporting_check_frequency_sec: 30

# agent.download:
#   # source of the artifacts, requires elastic like structure and naming of the binaries
#   # e.g /windows-x86.zip
#   sourceURI: "https://artifacts.elastic.co/downloads/beats/"
#   # path to the directory containing downloaded packages
#   target_directory: "${path.data}/downloads"
#   # timeout for downloading package
#   timeout: 120s
#   # install_path describes the location of installed packages/programs. It is also used
#   # for reading program specifications.
#   install_path: "${path.data}/install"
#   # retry_sleep_init_duration is the duration to sleep for before the first retry attempt. This
#   # duration will increase for subsequent retry attempts in a randomized exponential backoff manner.
#   retry_sleep_init_duration: 30s

# agent.process:
#   # timeout for creating new processes. when process is not successfully created by this timeout
#   # start operation is considered a failure
#   spawn_timeout: 30s
#   # timeout for stopping processes. when process is not stopped by this timeout then the process.
#   # is force killed
#   stop_timeout: 30s

# agent.grpc:
#   # listen address for the GRPC server that spawned processes connect back to.
#   address: localhost
#   # port for the GRPC server that spawned processes connect back to.
#   port: 6789
#   # max_message_size limits the message size in agent internal communication
#   # default is 100MB
#   max_message_size: 104857600

# agent.retry:
#   # Enabled determines whether retry is possible. Default is false.
#   enabled: true
#   # RetriesCount specifies number of retries. Default is 3.
#   # Retry count of 1 means it will be retried one time after one failure.
#   retriesCount: 3
#   # Delay specifies delay in ms between retries. Default is 30s
#   delay: 30s
#   # MaxDelay specifies maximum delay in ms between retries. Default is 300s
#   maxDelay: 5m
#   # Exponential determines whether delay is treated as exponential.
#   # With 30s delay and 3 retries: 30, 60, 120s
#   # Default is false
#   exponential: false

# agent.limits:
#   # limits the number of operating system threads that can execute user-level Go code simultaneously.
#   # Translates into the GOMAXPROCS runtime parameter for each Go process started by the agent and the agent itself.
#   # By default is set to `0` which means using all available CPUs.
#   go_max_procs: 0

# agent.monitoring:
#   # enabled turns on monitoring of running processes
#   enabled: false
#   # enables log monitoring
#   logs: false
#   # enables metrics monitoring
#   metrics: false
#   # metrics_period defines how frequent we should sample monitoring metrics. Default is 60 seconds.
#   metrics_period: 60s
#   # exposes /debug/pprof/ endpoints
#   # recommended that these endpoints are only enabled if the monitoring endpoint is set to localhost
#   pprof.enabled: false
#   # The name of the output to use for monitoring data.
#   use_output: monitoring
#   # Exposes agent metrics using http, by default sockets and named pipes are used.
#   #
#   # `http` Also exposes a /liveness endpoint that will return an HTTP code depending on agent status:
#   # 200: Agent is healthy
#   # 500: A component or unit is in a failed state
#   # 503: The agent coordinator is unresponsive
#   #
#   # You can pass a `failon` parameter to the /liveness endpoint to determine what component state will result in a 500.
#   # For example: `curl 'localhost:6792/liveness?failon=degraded'` will return 500 if a component is in a degraded state.
#   # The possible values for `failon` are:
#   # `degraded`: return an error if a component is in a degraded state or failed state, or if the agent coordinator is unresponsive.
#   # `failed`: return an error if a unit is in a failed state, or if the agent coordinator is unresponsive.
#   # `heartbeat`: return an error only if the agent coordinator is unresponsive.
#   # If no `failon` parameter is provided, the default behavior is `failon=heartbeat`
#   http:
#       # enables http endpoint
#       enabled: false
#       # The HTTP endpoint will bind to this hostname, IP address, unix socket or named pipe.
#       # When using IP addresses, it is recommended to only use localhost.
#       host: localhost
#       # Port on which the HTTP endpoint will bind. Default is 0 meaning feature is disabled.
#       port: 6791
#       # Metrics buffer endpoint
#       buffer.enabled: false
#   # Configuration for the diagnostics action handler
#   diagnostics:
#       # Rate limit for the action handler. Does not affect diagnostics collected through the CLI.
#       limit:
#           # Rate limit interval.
#           interval: 1m
#           # Rate limit burst.
#           burst: 1
#       # Configuration for the file-upload client. Client may retry failed requests with an exponential backoff.
#       uploader:
#           # Max retries allowed when uploading a chunk.
#           max_retries: 10
#           # Initial duration of the backoff.
#           init_dur: 1s
#           # Max duration of the backoff.
#           max_dur: 1m

# # Allow fleet to reload its configuration locally on disk.
# # Notes: Only specific process configuration and external input configurations will be reloaded.
# agent.reload:
#   # enabled configure the Elastic Agent to reload or not the local configuration.
#   #
#   # Default is true
#   enabled: true

#   # period define how frequent we should look for changes in the configuration.
#   period: 10s

# Feature Flags

# This section enables or disables feature flags supported by Agent and its components.
#agent.features:
#  fqdn:
#    enabled: false

# Logging

# There are four options for the log output: file, stderr, syslog, eventlog
# The file output is the default.

# Sets log level. The default log level is info.
# Available log levels are: error, warning, info, debug
#agent.logging.level: info

# Enable debug output for selected components. To enable all selectors use ["*"]
# Other available selectors are "beat", "publish", "service"
# Multiple selectors can be chained.
#agent.logging.selectors: [ ]

# Send all logging output to stderr. The default is false.
agent.logging.to_stderr: true

# Send all logging output to syslog. The default is false.
#agent.logging.to_syslog: false

# Send all logging output to Windows Event Logs. The default is false.
#agent.logging.to_eventlog: false

# If enabled, Elastic-Agent periodically logs its internal metrics that have changed
# in the last period. For each metric that changed, the delta from the value at
# the beginning of the period is logged. Also, the total values for
# all non-zero internal metrics are logged on shutdown. This setting is also passed
# to beats running under the agent. The default is true.
#agent.logging.metrics.enabled: true

# The period after which to log the internal metrics. The default is 30s.
#agent.logging.metrics.period: 30s

# Logging to rotating files. Set logging.to_files to false to disable logging to
# files.
#agent.logging.to_files: true
#agent.logging.files:
  # Configure the path where the logs are written. The default is the logs directory
  # under the home path (the binary location).
  #path: /var/log/elastic-agent

  # The name of the files where the logs are written to.
  #name: elastic-agent

  # Configure log file size limit. If limit is reached, log file will be
  # automatically rotated
  #rotateeverybytes: 20971520

  # Number of rotated log files to keep. Oldest files will be deleted first.
  #keepfiles: 7

  # The permissions mask to apply when rotating log files. The default value is 0600.
  # Must be a valid Unix-style file permissions mask expressed in octal notation.
  #permissions: 0600

  # Enable log file rotation on time intervals in addition to size-based rotation.
  # Intervals must be at least 1s. Values of 1m, 1h, 24h, 7*24h, 30*24h, and 365*24h
  # are boundary-aligned with minutes, hours, days, weeks, months, and years as
  # reported by the local system clock. All other intervals are calculated from the
  # Unix epoch. Defaults to disabled.
  #interval: 0

  # Rotate existing logs on startup rather than appending to the existing
  # file. Defaults to true.
  # rotateonstartup: true

# Set to true to log messages in JSON format.
#agent.logging.json: false

#=============================== Events Logging ===============================
# Some outputs will log raw events on errors like indexing errors in the
# Elasticsearch output, to prevent logging raw events (that may contain
# sensitive information) together with other log messages, a different
# log file, only for log entries containing raw events, is used. It will
# use the same level, selectors and all other configurations from the
# default logger, but it will have it's own file configuration.
#
# Having a different log file for raw events also prevents event data
# from drowning out the regular log files.
#
# IMPORTANT: No matter the default logger output configuration, raw events
# will **always** be logged to a file configured by `agent.logging.event_data.files`.

# agent.logging.event_data:
# Logging to rotating files. Set agent.logging.to_files to false to disable logging to
# files.
#agent.logging.event_data.to_files: true
#agent.logging.event_data:
  # Configure the path where the logs are written. The default is the logs directory
  # under the home path (the binary location).
  #path: /var/log/filebeat

  # The name of the files where the logs are written to.
  #name: filebeat-event-data

  # Configure log file size limit. If the limit is reached, log file will be
  # automatically rotated.
  #rotateeverybytes: 5242880

  # Number of rotated log files to keep. The oldest files will be deleted first.
  #keepfiles: 2

  # The permissions mask to apply when rotating log files. The default value is 0600.
  # Must be a valid Unix-style file permissions mask expressed in octal notation.
  #permissions: 0600

  # Enable log file rotation on time intervals in addition to the size-based rotation.
  # Intervals must be at least 1s. Values of 1m, 1h, 24h, 7*24h, 30*24h, and 365*24h
  # are boundary-aligned with minutes, hours, days, weeks, months, and years as
  # reported by the local system clock. All other intervals are calculated from the
  # Unix epoch. Defaults to disabled.
  #interval: 0

  # Rotate existing logs on startup rather than appending them to the existing
  # file. Defaults to false.
  # rotateonstartup: false

# Providers

# Providers supply the key/values pairs that are used for variable substitution
# and conditionals. Each provider's keys are automatically prefixed with the name
# of the provider.

# All registered providers are enabled by default.

# Disable all providers by default and only enable explicitly configured providers.
# agent.providers.initial_default: false

#providers:

# Agent provides information about the running agent.
#  agent:
#    enabled: true

# Docker provides inventory information from Docker.
#  docker:
#    enabled: true
#    host: "unix:///var/run/docker.sock"
#    cleanup_timeout: 60

# Env providers information about the running environment.
#  env:
#    enabled: true

# Host provides information about the current host.
#  host:
#    enabled: true

# Local provides custom keys to use as variable.
#  local:
#    enabled: true
#    vars:
#      foo: bar

# Local dynamic allows you to define multiple key/values to generate multiple configurations.
#  local_dynamic:
#    enabled: true
#    items:
#      - vars:
#          my_var: key1
#      - vars:
#          my_var: key2
#      - vars:
#          my_var: key3
```