﻿---
title: When to configure proxy settings
description: Configure proxy settings for Elastic Agent when it must connect through a proxy server to: Download artifacts from artifacts.elastic.co for subprocesses...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-proxy-config
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# When to configure proxy settings
Configure proxy settings for Elastic Agent when it must connect through a proxy server to:
- Download artifacts from `artifacts.elastic.co` for subprocesses or binary upgrades (use [Agent binary download settings](/docs/reference/fleet/fleet-settings#fleet-agent-binary-download-settings))
- Send data to Elasticsearch
- Retrieve agent policies from Fleet Server
- Retrieve agent policies from Elasticsearch (only needed for agents running Fleet Server)

![Image showing connections between Elastic Agent](https://www.elastic.co/docs/reference/fleet/images/agent-proxy-server.png)

If Fleet is unable to access the Elastic Package Registry because Kibana is behind a proxy server, you may also need to set the registry proxy URL in the Kibana configuration.
![Image showing connections between Fleet and the Elastic Package Registry](https://www.elastic.co/docs/reference/fleet/images/fleet-epr-proxy.png)