﻿---
title: Configure outputs for standalone Elastic Agents
description: The outputs section of the elastic-agent.yml file specifies where to send data. You can specify multiple outputs to pair specific inputs with specific...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-output-configuration
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure outputs for standalone Elastic Agents
The `outputs` section of the `elastic-agent.yml` file specifies where to send data. You can specify multiple outputs to pair specific inputs with specific outputs.
This example configures two outputs: `default` and  `monitoring`:
```yaml
outputs:
  default:
    type: elasticsearch
    hosts: [127.0.0.1:9200]
    api_key: "my_api_key"

  monitoring:
    type: elasticsearch
    api_key: VuaCfGcBCdbkQm-e5aOx:ui2lp2axTNmsyakw9tvNnw
    hosts: ["localhost:9200"]
    ca_sha256: "7lHLiyp4J8m9kw38SJ7SURJP4bXRZv/BNxyyXkCcE/M="
```

<note>
  A default output configuration is required.
</note>

Elastic Agent currently supports these outputs:
- [Elasticsearch](https://www.elastic.co/docs/reference/fleet/elasticsearch-output)
- [Kafka](https://www.elastic.co/docs/reference/fleet/kafka-output)
- [Logstash](https://www.elastic.co/docs/reference/fleet/logstash-output)