﻿---
title: Elastic Agent inputs
description: When you configure inputs for standalone Elastic Agents, the following values are supported for the input type parameter. Expand any section to view the...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-inputs-list
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent inputs
When you [configure inputs](https://www.elastic.co/docs/reference/fleet/elastic-agent-input-configuration) for standalone Elastic Agents, the following values are supported for the input `type` parameter.
**Expand any section to view the available inputs:**
<dropdown title="Audit the activities of users and processes on your systems">
  | Input                  | Description                                                                                                                                                                                                                                                                                                                                  | Learn more                                                                                                                      |
  |------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------|
  | `audit/auditd`         | Receives audit events from the Linux Audit Framework that is a part of the Linux kernel.                                                                                                                                                                                                                                                     | [Auditd Module](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-auditd) (Auditbeat docs)                 |
  | `audit/file_integrity` | Sends events when a file is changed (created, updated, or deleted) on disk. The events contain file metadata and hashes.                                                                                                                                                                                                                     | [File Integrity Module](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-file_integrity) (Auditbeat docs) |
  | `audit/system`         | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Collects various security related information about a system. All datasets send both periodic state information (for example, all currently running processes) and real-time changes (for example, when a new process starts or stops). | [System Module](https://www.elastic.co/docs/reference/beats/auditbeat/auditbeat-module-system) (Auditbeat docs)                 |
</dropdown>

<dropdown title="Collect metrics from operating systems and services running on your servers">
  | Input                   | Description                                                                                                                                                                                                                                                                               | Learn more                                                                                                                       |
  |-------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------|
  | `activemq/metrics`      | Periodically fetches JMX metrics from Apache ActiveMQ.                                                                                                                                                                                                                                    | [ActiveMQ module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-activemq) (Metricbeat docs)           |
  | `apache/metrics`        | Periodically fetches metrics from [Apache HTTPD](https://httpd.apache.org/) servers.                                                                                                                                                                                                      | [Apache module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-apache) (Metricbeat docs)               |
  | `aws/metrics`           | Periodically fetches monitoring metrics from AWS CloudWatch using [GetMetricData API](https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_GetMetricData.md) for AWS services.                                                                                            | [AWS module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-aws) (Metricbeat docs)                     |
  | `awsfargate/metrics`    | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Retrieves various metadata, network metrics, and Docker stats about tasks and containers.                                                                                            | [AWS Fargate module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-awsfargate) (Metricbeat docs)      |
  | `azure/metrics`         | Collects and aggregates Azure logs and metrics from a variety of sources into a common data platform where it can be used for analysis, visualization, and alerting.                                                                                                                      | [Azure module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-azure) (Metricbeat docs)                 |
  | `beat/metrics`          | Collects metrics about any Beat or other software based on libbeat.                                                                                                                                                                                                                       | [Beat module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-beat) (Metricbeat docs)                   |
  | `cloudfoundry/metrics`  | Connects to Cloud Foundry loggregator to gather container, counter, and value metrics into a common data platform where it can be used for analysis, visualization, and alerting.                                                                                                         | [Cloudfoundry module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-cloudfoundry) (Metricbeat docs)   |
  | `containerd/metrics`    | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Collects CPU, memory and blkio statistics about running containers controlled by containerd runtime.                                                                                 | [Containerd module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-containerd) (Metricbeat docs)       |
  | `docker/metrics`        | Fetches metrics from [Docker](https://www.docker.com/) containers.                                                                                                                                                                                                                        | [Docker module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-docker) (Metricbeat docs)               |
  | `elasticsearch/metrics` | Collects metrics about Elasticsearch.                                                                                                                                                                                                                                                     | [Elasticsearch module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-elasticsearch) (Metricbeat docs) |
  | `etcd/metrics`          | This module targets Etcd V2 and V3. When using V2, metrics are collected using [Etcd v2 API](https://coreos.com/etcd/docs/latest/v2/api.md). When using V3, metrics are retrieved from the `/metrics` endpoint as intended for [Etcd v3](https://coreos.com/etcd/docs/latest/metrics.md). | [Etcd module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-etcd) (Metricbeat docs)                   |
  | `gcp/metrics`           | Periodically fetches monitoring metrics from Google Cloud Platform using [Stackdriver Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp) for Google Cloud Platform services.                                                                                            | [Google Cloud Platform module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-gcp) (Metricbeat docs)   |
  | `haproxy/metrics`       | Collects stats from [HAProxy](http://www.haproxy.org/). It supports collection from TCP sockets, UNIX sockets, or HTTP with or without basic authentication.                                                                                                                              | [HAProxy module](https://www.elastic.co/docs/reference/beats/metricbeat) (Metricbeat docs)                                       |
  | `http/metrics`          | Used to call arbitrary HTTP endpoints for which a dedicated Metricbeat module is not available.                                                                                                                                                                                           | [HTTP module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-http) (Metricbeat docs)                   |
  | `iis/metrics`           | Periodically retrieve IIS web server related metrics.                                                                                                                                                                                                                                     | [IIS module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-iis) (Metricbeat docs)                     |
  | `jolokia/metrics`       | Collects metrics from [Jolokia agents](https://jolokia.org/reference/html/agents.html) running on a target JMX server or dedicated proxy server.                                                                                                                                          | [Jolokia module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-jolokia) (Metricbeat docs)             |
  | `kafka/metrics`         | Collects metrics from the [Apache Kafka](https://kafka.apache.org/intro) event streaming platform.                                                                                                                                                                                        | [Kafka module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kafka) (Metricbeat docs)                 |
  | `kibana/metrics`        | Collects metrics about Kibana.                                                                                                                                                                                                                                                            | [Kibana module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kibana) (Metricbeat docs)               |
  | `kubernetes/metrics`    | As one of the main pieces provided for Kubernetes monitoring, this module is capable of fetching metrics from several components.                                                                                                                                                         | [Kubernetes module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-kubernetes) (Metricbeat docs)       |
  | `linux/metrics`         | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Reports on metrics exclusive to the Linux kernel and GNU/Linux OS.                                                                                                                   | [Linux module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-linux) (Metricbeat docs)                 |
  | `logstash/metrics`      | collects metrics about Logstash.                                                                                                                                                                                                                                                          | [Logstash module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-logstash) (Metricbeat docs)           |
  | `memcached/metrics`     | Collects metrics about the [memcached](https://memcached.org/) memory object caching system.                                                                                                                                                                                              | [Memcached module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-memcached) (Metricbeat docs)         |
  | `mongodb/metrics`       | Periodically fetches metrics from [MongoDB](https://www.mongodb.com/) servers.                                                                                                                                                                                                            | [MongoDB module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mongodb) (Metricbeat docs)             |
  | `mssql/metrics`         | The [Microsoft SQL 2017](https://www.microsoft.com/en-us/sql-server/sql-server-2017) Metricbeat module. It is still under active development to add new Metricsets and introduce enhancements.                                                                                            | [MSSQL module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mssql) (Metricbeat docs)                 |
  | `mysql/metrics`         | Periodically fetches metrics from [MySQL](https://www.mysql.com/) servers.                                                                                                                                                                                                                | [MySQL module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-mysql) (Metricbeat docs)                 |
  | `nats/metrics`          | Uses the [Nats monitoring server APIs](https://nats.io/documentation/managing_the_server/monitoring/) to collect metrics.                                                                                                                                                                 | [NATS module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-nats) (Metricbeat docs)                   |
  | `nginx/metrics`         | Periodically fetches metrics from [Nginx](https://nginx.org/) servers.                                                                                                                                                                                                                    | [Nginx module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-nginx) (Metricbeat docs)                 |
  | `oracle/metrics`        | The [Oracle](https://www.oracle.com/) module for Metricbeat. It is under active development with feedback from the community. A single Metricset for Tablespace monitoring is added so the community can start gathering metrics from their nodes and contributing to the module.         | [Oracle module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-oracle) (Metricbeat docs)               |
  | `postgresql/metrics`    | Periodically fetches metrics from [PostgreSQL](https://www.postgresql.org/) servers.                                                                                                                                                                                                      | [PostgresSQL module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-postgresql) (Metricbeat docs)      |
  | `prometheus/metrics`    | Periodically scrapes metrics from [Prometheus exporters](https://prometheus.io/docs/instrumenting/exporters/).                                                                                                                                                                            | [Prometheus module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-prometheus) (Metricbeat docs)       |
  | `rabbitmq/metrics`      | Uses the [HTTP API](http://www.rabbitmq.com/management.html) created by the management plugin to collect RabbitMQ metrics.                                                                                                                                                                | [RabbitMQ module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-rabbitmq) (Metricbeat docs)           |
  | `redis/metrics`         | Periodically fetches metrics from [Redis](http://redis.io/) servers.                                                                                                                                                                                                                      | [Redis module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-redis) (Metricbeat docs)                 |
  | `sql/metrics`           | Allows you to execute custom queries against an SQL database and store the results in Elasticsearch.                                                                                                                                                                                      | [SQL module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-sql) (Metricbeat docs)                     |
  | `stan/metrics`          | Uses [STAN monitoring server APIs](https://github.com/nats-io/nats-streaming-server/blob/master/server/monitor.go) to collect metrics.                                                                                                                                                    | [Stan module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-stan) (Metricbeat docs)                   |
  | `statsd/metrics`        | Spawns a UDP server and listens for metrics in StatsD compatible format.                                                                                                                                                                                                                  | [Statsd module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-statsd) (Metricbeat docs)               |
  | `syncgateway/metrics`   | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Monitor a Sync Gateway instance by using its REST API.                                                                                                                               | [SyncGateway module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-syncgateway) (Metricbeat docs)     |
  | `system/metrics`        | Allows you to monitor your server metrics, including CPU, load, memory, network, processes, sockets, filesystem, fsstat, uptime, and more.                                                                                                                                                | [System module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-system) (Metricbeat docs)               |
  | `traefik/metrics`       | Periodically fetches metrics from a [Traefik](https://traefik.io/) instance.                                                                                                                                                                                                              | [Traefik module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-traefik) (Metricbeat docs)             |
  | `uwsgi/metrics`         | By default, collects the uWSGI stats metricset, using [StatsServer](https://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html).                                                                                                                                                        | [uWSGI module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-uwsgi) (Metricbeat docs)                 |
  | `vsphere/metrics`       | Uses the [Govmomi](https://github.com/vmware/govmomi) library to collect metrics from any Vmware SDK URL (ESXi/VCenter).                                                                                                                                                                  | [vSphere module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-vsphere) (Metricbeat docs)             |
  | `windows/metrics`       | Collects metrics from Windows systems.                                                                                                                                                                                                                                                    | [Windows module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-windows) (Metricbeat docs)             |
  | `zookeeper/metrics`     | Fetches statistics from the ZooKeeper service.                                                                                                                                                                                                                                            | [ZooKeeper module](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-zookeeper) (Metricbeat docs)         |
</dropdown>

<dropdown title="Forward and centralize log data">
  | Input                | Description                                                                                                                                                                                                                                             | Learn more                                                                                                                                |
  |----------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------|
  | `aws-cloudwatch`     | Stores log filesfrom Amazon Elastic Compute Cloud(EC2), AWS CloudTrail, Route53, and other sources.                                                                                                                                                     | [AWS CloudWatch input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-aws-cloudwatch) (Filebeat docs)                |
  | `aws-s3`             | Retrieves logs from S3 objects that are pointed to by S3 notification events read from an SQS queue or directly polling list of S3 objects in an S3 bucket.                                                                                             | [AWS S3 input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-aws-s3) (Filebeat docs)                                |
  | `azure-blob-storage` | Reads content from files stored in containers which reside on your Azure Cloud.                                                                                                                                                                         | [Azure Blob Storage](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-blob-storage) (Filebeat docs)              |
  | `azure-eventhub`     | Reads messages from an azure eventhub.                                                                                                                                                                                                                  | [Azure eventhub input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-azure-eventhub) (Filebeat docs)                |
  | `cel`                | Reads messages from a file path or HTTP API with a variety of payloads using the [Common Expression Language (CEL)](https://opensource.google.com/projects/cel) and the [mito](https://pkg.go.dev/github.com/elastic/mito/lib) CEL extension libraries. | [Common Expression Language input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cel) (Filebeat docs)               |
  | `cloudfoundry`       | Gets HTTP access logs, container logs and error logs from Cloud Foundry.                                                                                                                                                                                | [Cloud Foundry input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cloudfoundry) (Filebeat docs)                   |
  | `cometd`             | Streams the real-time events from a Salesforce generic subscription Push Topic.                                                                                                                                                                         | [CometD input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-cometd) (Filebeat docs)                                |
  | `container`          | Reads containers log files.                                                                                                                                                                                                                             | [Container input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-container) (Filebeat docs)                          |
  | `docker`             | Alias for `container`.                                                                                                                                                                                                                                  | -                                                                                                                                         |
  | `log/docker`         | Alias for `container`.                                                                                                                                                                                                                                  | n/a                                                                                                                                       |
  | `entity-analytics`   | Collects identity assets, such as users, from external identity providers.                                                                                                                                                                              | [Entity Analytics input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-entity-analytics) (Filebeat docs)            |
  | `event/file`         | Alias for `log`.                                                                                                                                                                                                                                        | n/a                                                                                                                                       |
  | `event/tcp`          | Alias for `tcp`.                                                                                                                                                                                                                                        | n/a                                                                                                                                       |
  | `filestream`         | Reads lines from active log files. Replaces and imporoves on the `log` input.                                                                                                                                                                           | [filestream input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-filestream) (Filebeat docs)                        |
  | `gcp-pubsub`         | Reads messages from a Google Cloud Pub/Sub topic subscription.                                                                                                                                                                                          | [GCP Pub/Sub input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcp-pubsub) (Filebeat docs)                       |
  | `gcs`                | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Reads content from files stored in buckets which reside on your Google Cloud.                                                                      | [Google Cloud Storage input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-gcs) (Filebeat docs)                     |
  | `http_endpoint`      | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Initializes a listening HTTP server that collects incoming HTTP POST requests containing a JSON body.                                              | [HTTP Endpoint input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-http_endpoint) (Filebeat docs)                  |
  | `httpjson`           | Read messages from an HTTP API with JSON payloads.                                                                                                                                                                                                      | [HTTP JSON input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-httpjson) (Filebeat docs)                           |
  | `journald`           | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> A system service that collects and stores logging data.                                                                                            | [Journald input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-journald) (Filebeat docs)                            |
  | `kafka`              | Reads from topics in a Kafka cluster.                                                                                                                                                                                                                   | [Kafka input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-kafka) (Filebeat docs)                                  |
  | `log`                | DEPRECATED: Use the `filestream` input instead.                                                                                                                                                                                                         | n/a                                                                                                                                       |
  | `logfile`            | Alias for `log`.                                                                                                                                                                                                                                        | n/a                                                                                                                                       |
  | `log/redis_slowlog`  | Alias for `redis`.                                                                                                                                                                                                                                      | n/a                                                                                                                                       |
  | `log/syslog`         | Alias for `syslog`.                                                                                                                                                                                                                                     | n/a                                                                                                                                       |
  | `mqtt`               | Reads data transmitted using lightweight messaging protocol for small and mobile devices, optimized for high-latency or unreliable networks.                                                                                                            | [MQTT input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-mqtt) (Filebeat docs)                                    |
  | `netflow`            | Reads NetFlow and IPFIX exported flows and options records over UDP.                                                                                                                                                                                    | [NetFlow input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-netflow) (Filebeat docs)                              |
  | `o365audit`          | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Retrieves audit messages from Office 365 and Azure AD activity logs.                                                                               | [Office 365 Management Activity API input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-o365audit) (Filebeat docs) |
  | `osquery`            | Collects and decodes the result logs written by [osqueryd](https://osquery.readthedocs.io/en/latest/introduction/using-osqueryd/) in the JSON format.                                                                                                   | -                                                                                                                                         |
  | `redis`              | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Reads entries from Redis slowlogs.                                                                                                                 | [Redis input](https://www.elastic.co/docs/reference/beats/filebeat) (Filebeat docs)                                                       |
  | `syslog`             | Reads Syslog events as specified by RFC 3164 and RFC 5424, over TCP, UDP, or a Unix stream socket.                                                                                                                                                      | [Syslog input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-syslog) (Filebeat docs)                                |
  | `tcp`                | Reads events over TCP.                                                                                                                                                                                                                                  | [TCP input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-tcp) (Filebeat docs)                                      |
  | `udp`                | Reads events over UDP.                                                                                                                                                                                                                                  | [UDP input](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-input-udp) (Filebeat docs)                                      |
  | `unix`               | <applies-to>Elastic Stack: Beta</applies-to> <applies-to>Elastic Cloud Serverless: Beta</applies-to> Reads events over a stream-oriented Unix domain socket.                                                                                            | [Unix input](https://www.elastic.co/docs/reference/beats/filebeat) (Filebeat docs)                                                        |
  | `winlog`             | Reads from one or more event logs using Windows APIs, filters the events based on user-configured criteria, then sends the event data to the configured outputs (Elasticsearch or Logstash).                                                            | [Winlogbeat Overview](https://www.elastic.co/docs/reference/beats/winlogbeat) (Winlogbeat docs)                                           |
</dropdown>

<dropdown title="Monitor the status of your services">
  | Input             | Description                                                                                      | Learn more                                                                                                  |
  |-------------------|--------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------|
  | `synthetics/http` | Connect via HTTP and optionally verify that the host returns the expected response.              | [HTTP options](https://www.elastic.co/docs/reference/beats/heartbeat/monitor-http-options) (Heartbeat docs) |
  | `synthetics/icmp` | Use ICMP (v4 and v6) Echo Requests to check the configured hosts.                                | [ICMP options](https://www.elastic.co/docs/reference/beats/heartbeat/monitor-icmp-options) (Heartbeat docs) |
  | `synthetics/tcp`  | Connect via TCP and optionally verify the endpoint by sending and/or receiving a custom payload. | [TCP options](https://www.elastic.co/docs/reference/beats/heartbeat/monitor-tcp-options) (Heartbeat docs)   |
</dropdown>

<dropdown title="View network traffic between the servers of your network">
  | Input    | Description                                                                                                                                | Learn more                                                                                      |
  |----------|--------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------|
  | `packet` | Sniffs the traffic between your servers, parses the application-level protocols on the fly, and correlates the messages into transactions. | [Packetbeat overview](https://www.elastic.co/docs/reference/beats/packetbeat) (Packetbeat docs) |
</dropdown>