﻿---
title: Configure inputs for standalone Elastic Agents
description: The inputs section of the elastic-agent.yml file specifies how Elastic Agent locates and processes input data. Sample metrics input configuration, Sample...
url: https://www.elastic.co/docs/reference/fleet/elastic-agent-input-configuration
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure inputs for standalone Elastic Agents
The `inputs` section of the `elastic-agent.yml` file specifies how Elastic Agent locates and processes input data.
- [Sample metrics input configuration](#elastic-agent-input-configuration-sample-metrics)
- [Sample log files input configuration](#elastic-agent-input-configuration-sample-logs)


## Sample metrics input configuration

By default Elastic Agent collects system metrics, such as CPU, memory, network, and file system metrics, and sends them to the default output. For example, to define data streams for `cpu`, `memory`, `network` and `filesystem` metrics, this is the configuration:
```yaml
- type: system/metrics 
  id: unique-system-metrics-id 
  data_stream.namespace: default 
  use_output: default 
  streams:
    - metricsets: 
      - cpu
      data_stream.dataset: system.cpu 
    - metricsets:
      - memory
      data_stream.dataset: system.memory
    - metricsets:
      - network
      data_stream.dataset: system.network
    - metricsets:
      - filesystem
      data_stream.dataset: system.filesystem
```


## Sample log files input configuration

To enable Elastic Agent to collect log files, you can use a configuration like the following.
```yaml
- type: filestream 
  id: your-input-id 
  streams:
    - id: your-filestream-stream-id 
      data_stream: 
        dataset: generic
      paths:
        - /var/log/*.log
```

The input in this example harvests all files in the path `/var/log/*.log`, that is, all logs in the directory `/var/log/` that end with `.log`. All patterns supported by [Go Glob](https://golang.org/pkg/path/filepath/#Glob) are also supported here.
To fetch all files from a predefined level of subdirectories, use this pattern: `/var/log/*/*.log`. This fetches all `.log` files from the subfolders of `/var/log`. It does not fetch log files from the `/var/log` folder itself. Currently it is not possible to recursively fetch all files in all subdirectories of a directory.