﻿---
title: Drop events
description: The drop_event processor drops the entire event if the associated condition is fulfilled. The condition is mandatory, because without one, all the events...
url: https://www.elastic.co/docs/reference/fleet/drop_event-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Drop events
The `drop_event` processor drops the entire event if the associated condition is fulfilled. The condition is mandatory, because without one, all the events are dropped.

## Example

```yaml
  - drop_event:
      when:
        condition
```

See [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions) for a list of supported conditions.
<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>