﻿---
title: Docker provider
description: Provides inventory information from Docker. The available dynamic variables are: To set the container ID dynamically in the configuration, use a variable...
url: https://www.elastic.co/docs/reference/fleet/docker-provider
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Docker provider
Provides inventory information from Docker. The available dynamic variables are:

| Key                           | Type     | Description             |
|-------------------------------|----------|-------------------------|
| `docker.container.id`         | `string` | ID of the container     |
| `docker.container.name`       | `string` | Name of the container   |
| `docker.container.image.name` | `string` | Image of the container  |
| `docker.container.labels`     | `object` | Labels of the container |

To set the container ID dynamically in the configuration, use a variable in the Elastic Agent policy to return container ID information from the provider:
```yaml
inputs:
  - id: 'docker-container-logs-${docker.container.id}'
    type: filestream
    paths:
      - '/var/lib/docker/containers/${docker.container.id}/*-json.log'
```

Sample of the policy generated by this configuration will look like:
```yaml
inputs:
  - id: docker-container-logs-b9b898d9c2a1126384d38e9f857b3985480cd05c8e74ffc8b628d92245f5a103
    streams:
      paths:
      - /var/lib/docker/containers/b9b898d9c2a1126384d38e9f857b3985480cd05c8e74ffc8b628d92245f5a103/*-json.log
    processors:
    - add_fields:
        fields:
          id: b9b898d9c2a1126384d38e9f857b3985480cd05c8e74ffc8b628d92245f5a103
          image: image-name:latest
          labels:
            key: value
          name: container-name
        target: container
  - id: docker-container-596bbd114498253985e6a5c4f0f7bf2d9eb8fcd4fe3e6cb53bdfba0cdc7036c8
    type: filestream
    streams:
      paths:
      - /var/lib/docker/containers/596bbd114498253985e6a5c4f0f7bf2d9eb8fcd4fe3e6cb53bdfba0cdc7036c8/*-json.log
    processors:
    - add_fields:
        fields:
          id: 596bbd114498253985e6a5c4f0f7bf2d9eb8fcd4fe3e6cb53bdfba0cdc7036c8
          image: other-image-name:latest
          labels:
            key: value
          name: other-container-name
        target: container
```

<note>
  Docker provider ensures that each docker container event is enriched with the container’s metadata, and hence the inputs will be populated with the `add_fields` processor which will be responsible for adding the proper container’s metadata.
</note>