﻿---
title: Detect mime type
description: The detect_mime_type processor attempts to detect a mime type for a field that contains a given stream of bytes. In this example, http.request.body.content...
url: https://www.elastic.co/docs/reference/fleet/detect_mime_type-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Detect mime type
The `detect_mime_type` processor attempts to detect a mime type for a field that contains a given stream of bytes.

## Example

In this example, `http.request.body.content` is used as the source, and `http.request.mime_type` is set to the detected mime type.
```yaml
  - detect_mime_type:
      field: http.request.body.content
      target: http.request.mime_type
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default | Description                                                                                                                             |
|----------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------|
| `field`  | Yes      |         | Field used as the data source.                                                                                                          |
| `target` | Yes      |         | Field to populate with the detected type. You can use the `@metadata.` prefix to set the value in the event metadata instead of fields. |

See [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions) for a list of supported conditions.