﻿---
title: Deployment models
description: There are various models for setting up Elastic Agents to work with Elasticsearch. The recommended approach is to use Fleet, a web-based UI in Kibana,...
url: https://www.elastic.co/docs/reference/fleet/deployment-models
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Deployment models
There are various models for setting up Elastic Agents to work with Elasticsearch. The recommended approach is to use Fleet, a web-based UI in Kibana, to centrally manage all of your Elastic Agents and their policies. Using Fleet requires having an instance of Fleet Server that acts as the interface between the Fleet UI and your Elastic Agents.
For an overview of Fleet Server, including details about how it communicates with Elasticsearch, how to ensure high availability, and more, refer to [What is Fleet Server?](https://www.elastic.co/docs/reference/fleet/fleet-server).
The requirements for setting up Fleet Server differ, depending on your particular deployment model:
<definitions>
  <definition term="Elastic Cloud Serverless">
    In a [Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment, Fleet Server is offered as a service, it is configured and scaled automatically without the need for any user intervention.
  </definition>
  <definition term="Elastic Cloud Hosted">
    If you’re running Elasticsearch and Kibana with [Elastic Cloud Hosted](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/cloud-hosted), no extra setup is required unless you want to scale your deployment. Elastic Cloud Hosted runs a hosted version of Integrations Server that includes Fleet Server. For details about this deployment model, refer to [Deploy on Elastic Cloud](https://www.elastic.co/docs/reference/fleet/add-fleet-server-cloud).
  </definition>
  <definition term="Elastic Cloud Hosted with Fleet Server on-premise">
    When you use an Elastic Cloud Hosted deployment you may still choose to run Fleet Server on-premise. For details about this deployment model and set up instructions, refer to [Deploy Fleet Server on-premises and Elasticsearch on Cloud](https://www.elastic.co/docs/reference/fleet/add-fleet-server-mixed).
  </definition>
  <definition term="Docker and Kubernetes">
    You can deploy Fleet-managed Elastic Agent in Docker or on Kubernetes. Refer to [Run Elastic Agent in a container](https://www.elastic.co/docs/reference/fleet/elastic-agent-container) or  [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet) for all of the configuration instructions. For a Kubernetes install we also have a [Helm chart](https://www.elastic.co/docs/reference/fleet/install-on-kubernetes-using-helm) available to simplify the installation. Details for configuring Fleet Server are included with the Elastic Agent install steps.
  </definition>
  <definition term="Elastic Cloud on Kubernetes">
    You can deploy Fleet-managed Elastic Agent in an Elastic Cloud Kubernetes environment that provides configuration and management capabilities for the full Elastic Stack. For details, refer to [Run Fleet-managed Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/fleet-managed-elastic-agent).
  </definition>
  <definition term="Self-managed">
    For self-managed deployments, you must install and host Fleet Server yourself. For details about this deployment model and set up instructions, refer to [Deploy on-premises and self-managed](https://www.elastic.co/docs/reference/fleet/add-fleet-server-on-prem).
  </definition>
</definitions>