﻿---
title: Decompress gzip fields
description: The decompress_gzip_field processor specifies a field to gzip decompress. To overwrite fields, either first rename the target field, or use the drop_fields...
url: https://www.elastic.co/docs/reference/fleet/decompress_gzip_field-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Decompress gzip fields
The `decompress_gzip_field` processor specifies a field to gzip decompress.
To overwrite fields, either first rename the target field, or use the `drop_fields` processor to drop the field, and then decompress the field.

## Example

In this example, `field1` is decompressed in `field2`.
```yaml
  - decompress_gzip_field:
      field:
        from: "field1"
        to: "field2"
      ignore_missing: false
      fail_on_error: true
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default | Description                                                                                                                                                                         |
|------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `field`          | Yes      |         | Contains:* `from: "old-key"`, where `from` is the origin* `to: "new-key"`, where `to` is the target field name                                                                      |
| `ignore_missing` | No       | `false` | Whether to ignore missing keys. If `true`, no error is logged if a key that should be decompressed is missing.                                                                      |
| `fail_on_error`  | No       | `true`  | If `true` and an error occurs, decompression of fields is stopped, and the original event is returned. If `false`, decompression continues even if an error occurs during decoding. |

See [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions) for a list of supported conditions.