﻿---
title: Decode duration
description: The decode_duration processor decodes a Go-style duration string into a specific format. For more information about the Go time.Duration string style,...
url: https://www.elastic.co/docs/reference/fleet/decode_duration-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Decode duration
The `decode_duration` processor decodes a Go-style duration string into a specific `format`.
For more information about the Go `time.Duration` string style, refer to the [Go documentation](https://pkg.go.dev/time#Duration).

## Example

```yaml
processors:
  - decode_duration:
      field: "app.rpc.cost"
      format: "milliseconds"
```


## Configuration settings


| Name     | Required | Default        | Description                                                   |
|----------|----------|----------------|---------------------------------------------------------------|
| `field`  | yes      |                | Which field of event needs to be decoded as `time.Duration`   |
| `format` | yes      | `milliseconds` | Supported formats: `milliseconds`/`seconds`/`minutes`/`hours` |