﻿---
title: Decode CEF
description: The decode_cef processor decodes Common Event Format (CEF) messages. In this example, the message field is decoded as CEF after it is renamed to event.original...
url: https://www.elastic.co/docs/reference/fleet/decode_cef-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Decode CEF
The `decode_cef` processor decodes Common Event Format (CEF) messages.
<note>
  This processor only works with log inputs.
</note>


## Example

In this example, the `message` field is decoded as CEF after it is renamed to `event.original`. It is best to rename `message` to `event.original` because the decoded CEF data contains its own `message` field.
```yaml
  - rename:
      fields:
        - {from: "message", to: "event.original"}
  - decode_cef:
      field: event.original
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default   | Description                                                                                                                                                                                                        |
|------------------|----------|-----------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `field`          | No       | `message` | Source field containing the CEF message to be parsed.                                                                                                                                                              |
| `target_field`   | No       | `cef`     | Target field where the parsed CEF object will be written.                                                                                                                                                          |
| `ecs`            | No       | `true`    | Whether to generate Elastic Common Schema (ECS) fields from the CEF data. Certain CEF header and extension values will be used to populate ECS fields.                                                             |
| `timezone`       | No       | `UTC`     | IANA time zone name (for example, `America/New_York`) or fixed time offset (for example, `+0200`) to use when parsing times that do not contain a time zone. Specify `Local` to use the machine’s local time zone. |
| `ignore_missing` | No       | `false`   | Whether to ignore errors when the source field is missing.                                                                                                                                                         |
| `ignore_failure` | No       | false     | Whether to ignore failures when the source field does not contain a CEF message.                                                                                                                                   |
| `id`             | No       |           | Identifier for this processor instance. Useful for debugging.                                                                                                                                                      |