﻿---
title: Scenario 4: Apply an ILM policy to all data streams in a custom integration
description: If you’ve created a custom integration package, you can apply a single ILM policy to all its data streams using a shared @custom component template. This...
url: https://www.elastic.co/docs/reference/fleet/data-streams-scenario4
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available since 9.1
---

# Scenario 4: Apply an ILM policy to all data streams in a custom integration
If you’ve created a custom integration package, you can apply a single ILM policy to all its data streams using a shared `@custom` component template. This eliminates the need to configure each data stream individually.

## Step 1: Define the ILM policy

1. In Kibana, go to the **Index Lifecycle Policies** management page. You can also use the [global search field](https://www.elastic.co/docs/explore-analyze/find-and-organize/find-apps-and-objects).
2. Click **Create policy**.
3. Name the policy, configure it as needed, and click **Save policy**.


## Step 2: Create a custom component template

Create a custom component template named `<integration>@custom`, replacing `<integration>` with your package name.
For example, for a Docker integration, use:
```json
PUT _component_template/docker@custom
{
  "template": {
    "settings": {
      "index": {
        "lifecycle": {
          "name": "docker-ilm-policy"
        }
      }
    },
    "mappings": {
      "properties":
      }
    }
  }
}
```


## Step 3: Deploy or update the integration

The `@custom` component template is automatically included when the package is installed or updated.
To apply the ILM policy:
- Bump the version of your custom package.
- Reinstall or upgrade the package using the Fleet UI or Developer Console.

After the ILM policy from `docker` has been deployed, it applies to all data streams in the package.