﻿---
title: Tutorials: Customize data retention policies
description: These tutorials explain how to apply a custom ILM policy to an integration’s data stream. For certain features you’ll need to use a slightly different...
url: https://www.elastic.co/docs/reference/fleet/data-streams-ilm-tutorial
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Tutorials: Customize data retention policies
These tutorials explain how to apply a custom ILM policy to an integration’s data stream.

## Before you begin

For certain features you’ll need to use a slightly different procedure to manage the index lifecycle:
- APM: For versions 8.15 and later, refer to [Index lifecycle management](https://www.elastic.co/docs/solutions/observability/apm/index-lifecycle-management).
- Synthetic monitoring: Refer to [Manage data retention](https://www.elastic.co/docs/solutions/observability/synthetics/manage-data-retention).
- Universal Profiling: Refer to [Universal Profiling index life cycle management](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/universal-profiling-index-life-cycle-management).


## Identify your scenario

How you apply an ILM policy depends on your use case. Choose a scenario for the detailed steps.
- **[Scenario 1](https://www.elastic.co/docs/reference/fleet/data-streams-scenario1)**: You want to apply an ILM policy to all logs or metrics data streams across all namespaces.
- **[Scenario 2](https://www.elastic.co/docs/reference/fleet/data-streams-scenario2)**: You want to apply an ILM policy to selected data streams in an integration.
- **[Scenario 3](https://www.elastic.co/docs/reference/fleet/data-streams-scenario3)**: You want to apply an ILM policy for data streams in a selected namespace in an integration.
- **[Scenario 4](https://www.elastic.co/docs/reference/fleet/data-streams-scenario4)**: You want to apply an ILM policy to all data streams in a custom integration using a `@custom` component template. <applies-to>Elastic Stack: Generally available since 9.1</applies-to>