﻿---
title: Enabling and disabling advanced indexing features for Fleet-managed data streams
description: Fleet provides support for several advanced features around its data streams, including: Time series data streams (TSDS), Synthetic _source. These features...
url: https://www.elastic.co/docs/reference/fleet/data-streams-advanced-features
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Enabling and disabling advanced indexing features for Fleet-managed data streams
Fleet provides support for several advanced features around its data streams, including:
- [Time series data streams (TSDS)](https://www.elastic.co/docs/manage-data/data-store/data-streams/time-series-data-stream-tsds)
- [Synthetic `_source`](https://www.elastic.co/docs/reference/elasticsearch/mapping-reference/mapping-source-field#synthetic-source)

These features can be enabled and disabled for Fleet-managed data streams by using the index template API and a few key settings. In versions 8.17.0 and later, synthetic `_source` is available only for certain [Elastic subscription levels](https://www.elastic.co/subscriptions).
<note>
  If you are already making use of `@custom` component templates for ingest or retention customization (as shown for example in [Tutorial: Customize data retention policies](https://www.elastic.co/docs/reference/fleet/data-streams-ilm-tutorial)), exercise care to ensure you don’t overwrite your customizations when making these requests.
</note>

We recommended using [Kibana Dev Tools](https://www.elastic.co/docs/explore-analyze/query-filter/tools) to run the following requests. Replace `<NAME>` with the name of a given integration data stream. For example specifying `metrics-nginx.stubstatus` results in making a PUT request to `_component_template/metrics-nginx.stubstatus@custom`. Use the index management interface to explore what integration data streams are available to you.
Once you’ve executed a given request below, you also need to execute a data stream rollover to ensure any incoming data is ingested with your new settings immediately. For example:
```sh
POST metrics-nginx.stubstatus-default/_rollover
```

Refer to the following steps to enable or disable advanced data stream features:
- [Disable synthetic `_source`](#data-streams-advanced-synthetic-disable)


## Enable TSDS

<note>
  TSDS uses synthetic `_source`, so if you want to trial both features you need to enable only TSDS.
</note>

Due to restrictions in the Elasticsearch API, TSDS must be enabled at the **index template** level. So, you’ll need to make some sequential requests to enable or disable TSDS.
1. Send a GET request to retrieve the index template:
   ```json
   GET _index_template/<NAME>
   ```
2. Use the JSON payload returned from the GET request to populate a PUT request, for example:
   ```json
   PUT _index_template/<NAME>
   {
     # You can copy & paste this directly from the GET request above
     "index_patterns": [
       "<index pattern from GET request>"
     ],

     # Make sure this is added
     "template": {
       "settings": {
         "index": {
           "mode": "time_series"
         }
       }
     },

     # You can copy & paste this directly from the GET request above
     "composed_of": [
       "<NAME>@package",
       "<NAME>@custom",
       ".fleet_globals-1",
       ".fleet_agent_id_verification-1"
     ],

     # You can copy & paste this directly from the GET request above
     "priority": 200,

     # Make sure this is added
     "data_stream": {
       "allow_custom_routing": false
     }
   }
   ```


## Disable TSDS

To disable TSDS, follow the same procedure as to [enable TSDS](#data-streams-advanced-tsds-enable), but specify `null` for `index.mode` instead of `time_series`. Follow the steps below or you can copy the [NGINX example](#data-streams-advanced-tsds-disable-nginx-example).
1. Send a GET request to retrieve the index template:
   ```json
   GET _index_template/<NAME>
   ```
2. Use the JSON payload returned from the GET request to populate a PUT request, for example:
   ```json
   PUT _index_template/<NAME>
   {
     # You can copy/paste this directly from the GET request above
     "index_patterns": [
       "<index pattern from GET request>"
     ],

     # Make sure this is added
     "template": {
       "settings": {
         "index": {
           "mode": null
         }
       }
     },

     # You can copy/paste this directly from the GET request above
     "composed_of": [
       "<NAME>@package",
       "<NAME>@custom",
       ".fleet_globals-1",
       ".fleet_agent_id_verification-1"
     ],

     # You can copy/paste this directly from the GET request above
     "priority": 200,

     # Make sure this is added
     "data_stream": {
       "allow_custom_routing": false
     }
   }
   ```
   For example, the following payload disables TSDS on `nginx.stubstatus`:
   
   ```json
   {
     "index_patterns": [
         "metrics-nginx.stubstatus-*"
     ],

     "template": {
       "settings": {
         "index": {
           "mode": null
         }
       }
     },

     "composed_of": [
       "metrics-nginx.stubstatus@package",
       "metrics-nginx.stubstatus@custom",
       ".fleet_globals-1",
       ".fleet_agent_id_verification-1"
     ],

     "priority": 200,

     "data_stream": {
       "allow_custom_routing": false
     }
   }
   ```


## Enable synthetic `_source`

```json
PUT _component_template/<NAME>@custom
{
  "settings": {
    "index": {
      "mapping": {
        "source": {
          "mode": "synthetic"
        }
      }
    }
  }
}
```


## Disable synthetic `_source`

```json
PUT _component_template/<NAME>@custom
{
  "settings": {
    "index": {
      "mapping": {
        "source": {"mode": "stored"}
      }
    }
  }
}
```