﻿---
title: Copy fields
description: The copy_fields processor takes the value of a field and copies it to a new field. You cannot use this processor to replace an existing field. If the...
url: https://www.elastic.co/docs/reference/fleet/copy_fields-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Copy fields
The `copy_fields` processor takes the value of a field and copies it to a new field.
You cannot use this processor to replace an existing field. If the target field already exists, you must [drop](https://www.elastic.co/docs/reference/fleet/drop_fields-processor) or [rename](https://www.elastic.co/docs/reference/fleet/rename-processor) the field before using `copy_fields`.

## Example

This configuration:
```yaml
  - copy_fields:
      fields:
        - from: message
          to: event.original
      fail_on_error: false
      ignore_missing: true
```

Copies the original `message` field to `event.original`:
```json
{
  "message": "my-interesting-message",
  "event": {
      "original": "my-interesting-message"
  }
}
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that your processor configurations cannot refer to fields that are created by ingest pipelines or Logstash. For more limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name             | Required | Default | Description                                                                                                                                                                          |
|------------------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `fields`         | Yes      |         | List of `from` and `to` pairs to copy from and to. You can use the `@metadata.` prefix to copy values from or to event metadata.                                                     |
| `fail_on_error`  | No       | `true`  | Whether to fail if an error occurs. If `true` and an error occurs, any changes are reverted, and the original is returned. If `false`, processing continues even if an error occurs. |
| `ignore_missing` | No       | `false` | Whether to ignore events that lack the source field. If `false`, the processing of an event will fail if a field is missing.                                                         |