﻿---
title: Configure standalone Elastic Agents
description: Standalone Elastic Agents are manually configured and managed locally on the systems where they are installed. They are useful when you are not interested...
url: https://www.elastic.co/docs/reference/fleet/configure-standalone-elastic-agents
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Configure standalone Elastic Agents
<tip>
  To get started quickly, use Kibana to create and download a standalone policy file. You’ll still need to deploy and manage the file, though. For more information, refer to [Create a standalone Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/create-standalone-agent-policy) or try out our example: [Use standalone Elastic Agent to monitor nginx](https://www.elastic.co/docs/reference/fleet/example-standalone-monitor-nginx).
</tip>

Standalone Elastic Agents are manually configured and managed locally on the systems where they are installed. They are useful when you are not interested in centrally managing agents in Fleet, either due to your company’s security requirements, or because you prefer to use another configuration management system.
To configure standalone Elastic Agents, specify settings in the `elastic-agent.yml` policy file deployed with the agent. Prior to installation, the file is located in the extracted Elastic Agent package. After installation, the file is copied to the directory described in [Installation layout](https://www.elastic.co/docs/reference/fleet/installation-layout). To apply changes after installation, you must modify the installed file.
For installation details, refer to [Install standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent).
Alternatively, you can put input configurations in YAML files into the folder `{path.config}/inputs.d` to separate your configuration into multiple smaller files. The YAML files in the `inputs.d` folder should contain input configurations only. Any other configurations are ignored. The files are reloaded at the same time as the standalone configuration.
<tip>
  The first line of the configuration must be `inputs`. Then you can list the inputs you would like to run. Each input in the policy must have a unique value for the `id` key. If the `id` key is missing its value defaults to the empty string `""`.
</tip>

```yaml
inputs:
  - id: unique-logfile-id
    type: logfile
    data_stream.namespace: default
    paths: [/path/to/file]
    use_output: default

  - id: unique-system-metrics-id
    type: system/metrics
    data_stream.namespace: default
    use_output: default
    streams:
      - metricsets:
          - cpu
        data_stream.dataset: system.cpu
```

The following sections describe some settings you might need to configure to run an Elastic Agent standalone. For a full reference example, refer to the [elastic-agent.reference.yml](https://www.elastic.co/docs/reference/fleet/elastic-agent-reference-yaml) file.
The settings described here are available for standalone Elastic Agents. Settings for Fleet-managed agents are specified through the UI. You do not set them explicitly in a policy file.