﻿---
title: Config file example: Nginx HTTP Server
description: Include these sample settings in your standalone Elastic Agent elastic-agent.yml configuration file to ingest data from Nginx HTTP Server. Nginx HTTP...
url: https://www.elastic.co/docs/reference/fleet/config-file-example-nginx
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Config file example: Nginx HTTP Server
Include these sample settings in your standalone Elastic Agent `elastic-agent.yml` configuration file to ingest data from Nginx HTTP Server.
- [Nginx HTTP Server logs](#config-file-example-nginx-logs)
- [Nginx HTTP Server metrics](#config-file-example-nginx-metrics)


## Nginx HTTP Server logs

```yaml
outputs: 
  default:
    type: elasticsearch 
    hosts:
      - '{elasticsearch-host-url}' 
    api_key: "my_api_key" 
agent:
  download: 
    sourceURI: 'https://artifacts.elastic.co/downloads/'
  monitoring: 
    enabled: true
    use_output: default
    namespace: default
    logs: true
    metrics: true
inputs: 
  - id: "insert a unique identifier here" 
    name: nginx-1
    type: logfile 
    use_output: default
    data_stream: 
      namespace: default
    streams:
      - id: "insert a unique identifier here" 
        data_stream:
          dataset: nginx.access 
          type: logs
        ignore_older: 72h
        paths: 
          - /var/log/nginx/access.log*
        tags:
          - nginx-access
        exclude_files:
          - .gz$
        processors:
          - add_locale: null
      - id: "insert a unique identifier here" 
        data_stream:
          dataset: nginx.error 
          type: logs
        ignore_older: 72h
        paths: 
          - /var/log/nginx/error.log*
        tags:
          - nginx-error
        exclude_files:
          - .gz$
        multiline:
          pattern: '^\d{4}\/\d{2}\/\d{2} '
          negate: true
          match: after
        processors:
          - add_locale: null
```


### Nginx HTTP Server metrics

```yaml
outputs: 
  default:
    type: elasticsearch 
    hosts:
      - '{elasticsearch-host-url}' 
    api_key: "my_api_key" 
agent:
  download: 
    sourceURI: 'https://artifacts.elastic.co/downloads/'
  monitoring: 
    enabled: true
    use_output: default
    namespace: default
    logs: true
    metrics: true
inputs: 
  - id: "insert a unique identifier here" 
    type: nginx/metrics 
    use_output: default
    data_stream: 
      namespace: default
    streams:
      - id: "insert a unique identifier here" 
        data_stream: 
          dataset: nginx.stubstatus 
          type: metrics
        metricsets: 
          - stubstatus
        hosts:
          - 'http://127.0.0.1:80'
        period: 10s
        server_status_path: /nginx_status
```