﻿---
title: Config file example: Apache HTTP Server
description: Include these sample settings in your standalone Elastic Agent elastic-agent.yml configuration file to ingest data from Apache HTTP server. Apache HTTP...
url: https://www.elastic.co/docs/reference/fleet/config-file-example-apache
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Config file example: Apache HTTP Server
Include these sample settings in your standalone Elastic Agent `elastic-agent.yml` configuration file to ingest data from Apache HTTP server.
- [Apache HTTP Server logs](#config-file-example-apache-logs)
- [Apache HTTP Server metrics](#config-file-example-apache-metrics)


## Apache HTTP Server logs

```yaml
outputs: 
  default:
    type: elasticsearch 
    hosts:
      - '{elasticsearch-host-url}' 
    api_key: "my_api_key" 
agent:
  download: 
    sourceURI: 'https://artifacts.elastic.co/downloads/'
  monitoring: 
    enabled: true
    use_output: default
    namespace: default
    logs: true
    metrics: true
inputs: 
  - id: "insert a unique identifier here" 
    name: apache-1
    type: logfile 
    use_output: default
    data_stream: 
      namespace: default
    streams:
      - id: "insert a unique identifier here" 
        data_stream:
          dataset: apache.access 
          type: logs
        paths: 
          - /var/log/apache2/access.log*
          - /var/log/apache2/other_vhosts_access.log*
          - /var/log/httpd/access_log*
        tags:
          - apache-access
        exclude_files:
          - .gz$
      - id: "insert a unique identifier here" 
        data_stream:
          dataset: apache.error 
          type: logs
        paths: 
          - /var/log/apache2/error.log*
          - /var/log/httpd/error_log*
        exclude_files:
          - .gz$
        tags:
          - apache-error
        processors:
          - add_locale: null
```


## Apache HTTP Server metrics

```yaml
outputs: 
  default:
    type: elasticsearch 
    hosts:
      - '{elasticsearch-host-url}' 
    api_key: "my_api_key" 
agent:
  download: 
    sourceURI: 'https://artifacts.elastic.co/downloads/'
  monitoring: 
    enabled: true
    use_output: default
    namespace: default
    logs: true
    metrics: true
inputs: 
    type: apache/metrics 
    use_output: default
    data_stream: 
      namespace: default
    streams:
      - id: "insert a unique identifier here" 
        data_stream: 
          dataset: apache.status 
          type: metrics
        metricsets: 
          - status
        hosts:
          - 'http://127.0.0.1'
        period: 30s
        server_status_path: /server-status
```