﻿---
title: Community ID Network Flow Hash
description: The community_id processor computes a network flow hash according to the Community ID Flow Hash specification. The flow hash is useful for correlating...
url: https://www.elastic.co/docs/reference/fleet/community_id-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Community ID Network Flow Hash
The `community_id` processor computes a network flow hash according to the [Community ID Flow Hash specification](https://github.com/corelight/community-id-spec).
The flow hash is useful for correlating all network events related to a single flow. For example, you can filter on a community ID value and you might get back the Netflow records from multiple collectors and layer 7 protocol records from the Network Packet Capture integration.
By default the processor is configured to read the flow parameters from the appropriate Elastic Common Schema (ECS) fields. If you are processing ECS data, no parameters are required.

## Examples

```yaml
  - community_id:
```

If the data does not conform to ECS, you can customize the field names that the processor reads from. You can also change the target field that the computed hash is written to. For example:
```yaml
  - community_id:
      fields:
        source_ip: my_source_ip
        source_port: my_source_port
        destination_ip: my_dest_ip
        destination_port: my_dest_port
        iana_number: my_iana_number
        transport: my_transport
        icmp_type: my_icmp_type
        icmp_code: my_icmp_code
      target: network.community_id
```

If the necessary fields are not present in the event, the processor silently continues without adding the target field.

## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|----------|----------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `fields` | No       |         | Field names that the processor reads from:`source_ip`:   Field containing the source IP address.`source_port`:   Field containing the source port.`destination_ip`:   Field containing the destination IP address.`destination_port`:   Field containing the destination port.`iana_number`:   Field containing the IANA number. The following protocol numbers are currently supported: 1 ICMP, 2 IGMP, 6 TCP, 17 UDP, 47 GRE, 58 ICMP IPv6, 88 EIGRP, 89 OSPF, 103 PIM, and 132 SCTP.`transport`:   Field containing the transport protocol. Used only when the `iana_number` field is not present.`icmp_type`:   Field containing the ICMP type.`icmp_code`:   Field containing the ICMP code. |
| `target` | No       |         | Field that the computed hash is written to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `seed`   | No       |         | Seed for the community ID hash. Must be between 0 and 65535 (inclusive). The seed can prevent hash collisions between network domains, such as a staging and production network that use the same addressing scheme. This setting results ina 16-bit unsigned integer that gets incorporated into all generated hashes.                                                                                                                                                                                                                                                                                                                                                                           |