﻿---
title: Rotate SSL/TLS CA certificates
description: In some scenarios you may want to rotate your configured certificate authorities (CAs), for instance if your chosen CAs are due to expire. Refer to the...
url: https://www.elastic.co/docs/reference/fleet/certificates-rotation
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Stack: Generally available
---

# Rotate SSL/TLS CA certificates
In some scenarios you may want to rotate your configured certificate authorities (CAs), for instance if your chosen CAs are due to expire. Refer to the following steps to rotate certificates between connected components:
- [Rotating a Fleet Server CA](#certificates-rotation-agent-fs)
- [Rotating an Elasticsearch CA for connections from Fleet Server](#certificates-rotation-fs-es)
- [Rotating an Elasticsearch CA for connections from Elastic Agent](#certificates-rotation-agent-es)

For important notes about current limitations (such as restart requirements and unsupported features), refer to [Limitations](#limitations).

## Rotating a Fleet Server CA

Elastic Agent communicates with Fleet Server to receive policies and to check for updates. There are two methods to rotate a CA certificate on Fleet Server for connections from Elastic Agent. The first method requires Elastic Agent to re-enroll with Fleet Server one or more times. The second method avoids re-enrollment and requires overwriting the existing CA file with a new certificate.
**Option 1: To renew an expiring CA certificate on Fleet Server with Elastic Agent re-enrollments**
Using this method, the Elastic Agent with an old or expiring CA configured will be re-enrolled with Fleet Server using a new CA.
1. Update the Elastic Agent with the new Fleet Server CA:
   The Elastic Agent should already have a CA configured. Use the [`elastic-agent enroll`](/docs/reference/fleet/agent-command-reference#elastic-agent-enroll-command) command to re-enroll the agent with an updated, comma separated set of CAs to use.
   ```shell
   elastic-agent enroll \
     --url=<Fleet-Server-URL> \
     --enrollment-token=<enrollment-token> \
     ... \
     --certificate-authorities <original_CA, new_CA>
   ```
   A new agent enrollment will cause a new agent to appear in Fleet. This may be considered disruptive, however the old agent entry will transition to an offline state. A new agent enrollment is required in order for the Fleet Server configuration to be modified to accept multiple certificate authorities.
   At this point, all TLS connections are still relying on the original CA that was provided (`original_CA`) in order to authenticate Fleet Server certificates.
2. Rotate the certificates on Fleet Server:
   This procedure will reissue new certificates based on the new CA. Re-enroll Fleet Server with all the new certificates:
   ```shell
   elastic-agent enroll ...
     --url=<Fleet-Server-URL> \
     --enrollment-token=<enrollment-token> \
     ... \
     --fleet-server-cert <new_cert> --certificate-authorities <new_CA>
   ```
   This will cause the TLS connections to the Elastic Agents to reset and will load the relevant new CA and certificates to the Fleet Server configuration.
3. The Elastic Agents will automatically establish new TLS connections as part of their normal operation:
   The new CA (`new_CA`) on the agent installed in Step 1 will be used to authenticate the certificates used by Fleet Server.
   If the original CA (`original CA`) was compromised, then it may need to be removed from the agent's CA list. To achieve this you need to enroll the agent again:
   ```shell
   elastic-agent enroll ...
     --url=<Fleet-Server-URL> \
     --enrollment-token=<enrollment-token> \
     ... \
     --certificate-authorities <new_CA>
   ```

**Option 2: To renew an expiring CA certificate on Fleet Server without Elastic Agent re-enrollments**
Option 1 results in multiple Elastic Agent enrollments. Another option to avoid multiple enrollments is to overwrite the CA files with the new CA or certificate. This method uses a single file with multiple CAs that can be replaced.
To use this option it is assumed that:
- Elastic Agents have already been enrolled using a file that contains the Certificate Authority:
  ```shell
  elastic-agent enroll ...
    --url=<Fleet-Server-URL> \
    --enrollment-token=<enrollment-token> \
    ... \
    --certificate-authorities=<CA.pem>
  ```
- The Elastic Agent running Fleet Server has already been enrolled with the following secure connection options, where each option points to files that contain the certificates and keys:
  ```shell
  elastic-agent enroll ...
    --url=<Fleet-Server-URL> \
    --enrollment-token=<enrollment-token> \
    ... \
    --certificate-authorities=<CA.pem> \
    --fleet-server-cert=<fleet-cert.pem> \
    --fleet-server-cert-key=<key.pem>
  ```

To update the Elastic Agent and Fleet Server configurations:
1. Update the configuration with the new CA by changing the content of `CA.pem` to include the new CA.
   ```shell
   cat new_ca.pem >> CA.pem
   ```
2. Restart the Elastic Agents. This is not a re-enrollment–restarting will force the Elastic Agents to reload the CAs.
   ```shell
   elastic-agent restart
   ```
3. For the Elastic Agent that is running Fleet Server, overwrite the original `certificate`, `certificate-key`, and the `certificate-authority` with the new ones to use.
   ```shell
   cat new-cert.pem > cert.pem
   cat new-key.pem > key.pem
   cat new_ca.pem > CA.pem
   ```
4. Restart the Elastic Agent that is running Fleet Server.
   ```shell
   elastic-agent restart
   ```
5. If the original certificate needs to be removed from the Elastic Agents, overwrite the `CA.pem` with the new CA only:
   ```shell
   cat new_ca.pem > CA.pem
   ```
6. Finally, restart the Elastic Agents again.
   ```shell
   elastic-agent restart
   ```


## Rotating an Elasticsearch CA for connections from Fleet Server

Fleet Server communicates with Elasticsearch to send status information to Fleet about Elastic Agents and to retrieve updated policies to ship out to all Elastic Agents enrolled in a given policy. If you have Fleet Server  [deployed on-premise](https://www.elastic.co/docs/reference/fleet/deployment-models), you may wish to rotate your configured CA certificate, for instance if the certificate is due to expire.
To rotate a CA certificate on Elasticsearch for connections from Fleet Server:
1. Update the Fleet Server with the new Fleet Server CA:
   The Elastic Agent running Fleet Server should already have a CA configured. Use the [`elastic-agent enroll`](/docs/reference/fleet/agent-command-reference#elastic-agent-enroll-command) command to re-enroll the agent running Fleet Server with an updated, comma separated set of CAs to use.
   ```shell
   elastic-agent enroll \
     --fleet-server-es=<Elasticsearch-URL> \
     --fleet-server-service-token=<service-token> \
     ... \
     --fleet-server-es-ca <original_ES_CA, new_ES_CA>
   ```
   A new agent enrollment will cause two Fleet Server agents to appear in Fleet. This may be considered disruptive, however the old agent entry will transition to offline. A new agent enrollment is required in order for the Fleet Server configuration to be modified to accept multiple certificate authorities.
   At this point, all TLS connections are still relying on the original CA that was provided (`original_ES_CA`) in order to authenticate Elasticsearch certificates. Re-enrolling the Fleet Server will cause the agents going through that Fleet Server to also reset their TLS, but the connections will be re-established as required.
2. Rotate the certificates on Elasticsearch.
   Elasticsearch will use new certificates based on the new Elasticsearch CA. Since the Fleet Server has the original and the new Elasticsearch CAs in a chain, it will accept original and new certificates from Elasticsearch.
   If the original Elasticsearch CA (`original_ES CA`) was compromised, then it may need to be removed from the Fleet Server's CA list. To achieve this you need to enroll the Fleet Server agent again (if re-enrollment is a concern then use a file to hold the certificates and certificate-authority):
   ```shell
   elastic-agent enroll \
     --fleet-server-es=<Elasticsearch-URL> \
     --fleet-server-service-token=<service-token> \
     ... \
     --fleet-server-es-ca <new_ES_CA>
   ```


## Rotating an Elasticsearch CA for connections from Elastic Agent

Using configuration information from a policy delivered by Fleet Server, Elastic Agent collects data and sends it to Elasticsearch.
To rotate a CA certificate on Elasticsearch for connections from Elastic Agent:
1. In Fleet open the **Settings** tab.
2. In the **Outputs** section, click the edit button for the Elasticsearch output that requires a certificate rotation.
3. In the **Elasticsearch CA trusted fingerprint** field, add the new trusted fingerprint to use. This is the SHA-256 fingerprint (hash) of the certificate authority used to self-sign Elasticsearch certificates. This fingerprint will be used to verify self-signed certificates presented by Elasticsearch.
   If this certificate is present in the chain during the handshake, it will be added to the `certificate_authorities` list and the handshake will continue normally.
   ![Screen capture of the Edit Output UI: Elasticsearch CA trusted fingerprint](https://www.elastic.co/docs/reference/fleet/images/certificate-rotation-agent-es.png)


## Limitations

Keep the following in mind when rotating certificates and certificate authorities (CAs):
- **Agent restart required**
  Elastic Agent does not support hot reloading of updated certificates or CA files. You must restart the agent to apply changes.
- **Directory loading not supported**
  Unlike Beats, Elastic Agent does not support passing a directory of CAs (for example, `--capath`) or monitoring a directory for changes. You must reference a specific file.
- **Rotation without re-enrollment**
  When rotating a CA, you can avoid agent re-enrollment by including both the old and new CAs in the configured CA file, restarting the agent, and then removing the old CA after the switch.
- **Mutual TLS (`--fleet-server-client-auth=required`)**
  If mTLS is enabled, you must apply the same overlap approach (adding a new CA before removing the old) on both client and server. The rotation process itself is otherwise unchanged.