﻿---
title: Beats and Elastic Agent capabilities
description: Elastic provides two main ways to send data to Elasticsearch: Beats are lightweight data shippers that send operational data to Elasticsearch. Elastic...
url: https://www.elastic.co/docs/reference/fleet/beats-agent-comparison
products:
  - Beats
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Beats and Elastic Agent capabilities
Elastic provides two main ways to send data to Elasticsearch:
- **Beats** are lightweight data shippers that send operational data to Elasticsearch. Elastic provides separate Beats for different types of data, such as logs, metrics, and uptime. Depending on what data you want to collect, you may need to install multiple shippers on a single host.
- **Elastic Agent** is a single agent for logs, metrics, security data, and threat prevention. The Elastic Agent can be deployed in two different modes:
  - **Managed by Fleet** — The Elastic Agent policies and lifecycle are centrally managed by the Fleet app in Kibana. The Integrations app also lets you centrally add integrations with other popular services and systems. This is the recommended option for most users.
- **Standalone mode** — All policies are applied to the Elastic Agent manually as a YAML file. This is intended for more advanced users. See [Install standalone Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-standalone-elastic-agent) for more information.

The method you use depends on your use case, which features you need, and whether you want to centrally manage your agents.
Beats and Elastic Agent can both send data directly to Elasticsearch or through Logstash, where you can further process and enhance the data, before visualizing it in Kibana.
This article summarizes the features and functionality you need to be aware of before adding new Elastic Agents or replacing your current Beats with Elastic Agents. Starting in version 7.14.0, Elastic Agent is generally available (GA).

## Choosing between Elastic Agent and Beats

Elastic Agent is a single binary designed to provide the same functionality that the various Beats provide today. However, some functionality gaps are being addressed as we strive to reach feature parity.
The following steps will help you determine if Elastic Agent can support your use case:
1. Determine if the integrations you need are supported and Generally Available (GA) on Elastic Agent. To find out if an integration is GA, see the [Integrations quick reference table](https://www.elastic.co/docs/reference/integrations/all_integrations).
2. If the integration is available, check [Supported outputs](#supported-outputs-beats-and-agent) to see whether the required output is also supported.
3. Review [Capabilities comparison](#additional-capabilities-beats-and-agent) to determine if any features required by your deployment are supported. Elastic Agent should support most of the features available on Beats and is updated for each release.

If you are satisfied with all three steps, then Elastic Agent is suitable for your deployment. However, if any steps fail your assessment, you should continue using Beats, and review future updates or contact us in the [discuss forum](https://discuss.elastic.co/).

## Supported inputs

For Elastic Agents that are centrally managed by Fleet, data collection is further simplified and defined by integrations. In this model, the decision on the inputs is driven by the integration you want to collect data from. The complexity of configuration details of various inputs is driven centrally by Fleet and specifically by the integrations.
To find out if an integration is GA, see the [Integrations quick reference table](https://www.elastic.co/docs/reference/integrations/all_integrations).

## Supported outputs

The following table shows the outputs supported by the Elastic Agent in 9.0.0-beta1:
<note>
  Elastic Defend and APM Server have a different output matrix.
</note>


| Output                | Beats                                                                      | Fleet-managed Elastic Agent                                                | Standalone Elastic Agent                                                   |
|-----------------------|----------------------------------------------------------------------------|----------------------------------------------------------------------------|----------------------------------------------------------------------------|
| Elasticsearch Service | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) |
| Elasticsearch         | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) |
| Logstash              | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) |
| Kafka                 | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) |
| Remote Elasticsearch  | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) |
| Redis                 | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        |
| File                  | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        |
| Console               | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        |


## Supported configurations


| Beats configuration                                                                                                          | Elastic Agent support                                                                                                                                                                                       |
|------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Modules](https://www.elastic.co/docs/reference/beats/filebeat/configuration-filebeat-modules)                               | Supported through integrations.                                                                                                                                                                             |
| [Input setting overrides](https://www.elastic.co/docs/reference/beats/filebeat/advanced-settings)                            | Not configurable. Set to default values.                                                                                                                                                                    |
| [General settings](https://www.elastic.co/docs/reference/beats/filebeat/configuration-general-options)                       | Many of these global settings are now internal to the agent and should not be modified.                                                                                                                     |
| [Project paths](https://www.elastic.co/docs/reference/beats/filebeat/configuration-path)                                     | Elastic Agent configures these paths to provide a simpler and more streamlined configuration experience.                                                                                                    |
| [External configuration file loading](https://www.elastic.co/docs/reference/beats/filebeat/filebeat-configuration-reloading) | Config is distributed through policy.                                                                                                                                                                       |
| [Live reloading](https://www.elastic.co/docs/reference/beats/filebeat/_live_reloading)                                       | Related to the config file reload.                                                                                                                                                                          |
| [Outputs](https://www.elastic.co/docs/reference/beats/filebeat/configuring-output)                                           | Configured through Fleet. See [Supported outputs](#supported-outputs-beats-and-agent).                                                                                                                      |
| [SSL](https://www.elastic.co/docs/reference/beats/filebeat/configuration-ssl)                                                | Supported                                                                                                                                                                                                   |
| [Index lifecycle management](https://www.elastic.co/docs/reference/beats/filebeat/ilm)                                       | Enabled by default although the Agent uses [data streams](https://www.elastic.co/docs/reference/fleet/data-streams).                                                                                        |
| [Elasticsearch index template loading](https://www.elastic.co/docs/reference/beats/filebeat/configuration-template)          | No longer applicable                                                                                                                                                                                        |
| [Kibana endpoint](https://www.elastic.co/docs/reference/beats/filebeat/setup-kibana-endpoint)                                | New Elastic Agent workflow doesn’t need this.                                                                                                                                                               |
| [Kibana dashboard loading](https://www.elastic.co/docs/reference/beats/filebeat/configuration-dashboards)                    | New Elastic Agent workflow doesn’t need this.                                                                                                                                                               |
| [Processors](https://www.elastic.co/docs/reference/beats/filebeat/defining-processors)                                       | Processors can be defined at the integration level. Global processors, configured at the policy level, are currently under consideration.                                                                   |
| [Autodiscover](https://www.elastic.co/docs/reference/beats/filebeat/configuration-autodiscover)                              | Autodiscover is facilitated through [dynamic inputs](https://www.elastic.co/docs/reference/fleet/dynamic-input-configuration). Elastic Agent does not support hints-based autodiscovery.                    |
| [Internal queues](https://www.elastic.co/docs/reference/beats/filebeat/configuring-internal-queue)                           | Fleet-managed Elastic Agent and Standalone Elastic Agent both support configuration of the internal memory queues by an end user. Neither support configuration of the internal disk queues by an end user. |
| [Load balance output hosts](https://www.elastic.co/docs/reference/beats/filebeat/elasticsearch-output#_loadbalance)          | Within the Fleet UI, you can add YAML settings to configure multiple hosts per output type, which enables load balancing.                                                                                   |
| [Logging](https://www.elastic.co/docs/reference/beats/filebeat/configuration-logging)                                        | Supported                                                                                                                                                                                                   |
| [HTTP endpoint](https://www.elastic.co/docs/reference/beats/filebeat/http-endpoint)                                          | Supported                                                                                                                                                                                                   |
| [Regular expressions](https://www.elastic.co/docs/reference/beats/filebeat/regexp-support)                                   | Supported                                                                                                                                                                                                   |


## Capabilities comparison

The following table shows a comparison of capabilities supported by Beats and the Elastic Agent in 9.0.0-beta1:

| Item                                                                   | Beats                                                                      | Fleet-managed Elastic Agent                                                                                                                     | Standalone Elastic Agent                                                                           | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|------------------------------------------------------------------------|----------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Single agent for all use cases                                         | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Elastic Agent provides logs, metrics, and more. You’d need to install multiple Beats for these use cases.                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Install integrations from web UI or API                                | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Elastic Agent integrations are installed with a convenient web UI or API, but Beats modules are installed with a CLI. This installs Elasticsearch assets such as index templates and ingest pipelines, and Kibana assets such as dashboards.                                                                                                                                                                                                                                                                               |
| Configure from web UI or API                                           | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)(optional)               | Fleet-managed Elastic Agent integrations can be configured in the web UI or API. Standalone Elastic Agent can use the web UI, API, or YAML. Beats can only be configured through YAML files.                                                                                                                                                                                                                                                                                                                               |
| Central, remote agent policy management                                | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | Elastic Agent policies can be centrally managed through Fleet. You have to manage Beats configuration yourself or with a third-party solution.                                                                                                                                                                                                                                                                                                                                                                             |
| Central, remote agent binary upgrades                                  | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | Elastic Agents can be remotely upgraded through Fleet. You have to upgrade Beats yourself or with a third-party solution.                                                                                                                                                                                                                                                                                                                                                                                                  |
| Add Kibana and Elasticsearch assets for a single integration or module | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Elastic Agent integrations allow you to add Kibana and Elasticsearch assets for a single integration at a time. Beats installs hundreds of assets for all modules at once.                                                                                                                                                                                                                                                                                                                                                 |
| Auto-generated Elasticsearch API keys                                  | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | Fleet can automatically generate API keys with limited permissions for each Elastic Agent, which can be individually revoked. Standalone Elastic Agent and Beats require you to create and manage credentials, and users often share them across hosts.                                                                                                                                                                                                                                                                    |
| Auto-generate minimal Elasticsearch permissions                        | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | Fleet can automatically give Elastic Agents minimal output permissions based on the inputs running. With standalone Elastic Agent and Beats, users often give overly broad permissions because it’s more convenient.                                                                                                                                                                                                                                                                                                       |
| Data streams support                                                   | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Both Beats (default as of version 8.0) and Elastic Agents use [data streams](https://www.elastic.co/docs/reference/fleet/data-streams) with easier index life cycle management and the [data stream naming scheme](https://www.elastic.co/blog/an-introduction-to-the-elastic-data-stream-naming-scheme).                                                                                                                                                                                                                  |
| Variables and input conditions                                         | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)        | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)(limited)                                                             | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Elastic Agent offers [variables and input conditions](https://www.elastic.co/docs/reference/fleet/dynamic-input-configuration) to dynamically adjust based on the local host environment. Users can configure these directly in YAML for standalone Elastic Agent or using the Fleet API for Fleet-managed Elastic Agent. The Integrations app allows users to enter variables, and we are considering a [UI to edit conditions](https://github.com/elastic/kibana/issues/108525). Beats only offers static configuration. |
| Allow non-superusers to manage assets and agents                       | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) (optional)              | Starting with version 8.1.0, a superuser role is no longer required to use the Fleet and Integrations apps and corresponding APIs. These apps are optional for standalone Elastic Agent. Beats offers [finer grained](https://www.elastic.co/docs/reference/beats/filebeat/feature-roles) roles.                                                                                                                                                                                                                           |
| Air-gapped network support                                             | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)(limited)                                                             | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | The Integrations and Fleet apps can be deployed in an air-gapped environment [self-managed deployment of the Elastic Package Registry](/docs/reference/fleet/air-gapped#air-gapped-diy-epr). Fleet-managed Elastic Agents require a connection to our artifact repository for agent binary upgrades. However the policy can be modified to have agents point to a local server in order to fetch the agent binary.                                                                                                         |
| Run without root on host                                               | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Fleet-managed Elastic Agents, Standalone Elastic Agents, and Beats require root permission only if they’re configured to capture data that requires that level of permission.                                                                                                                                                                                                                                                                                                                                              |
| Multiple outputs                                                       | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | The policy for a single Fleet-managed Elastic Agent can specify multiple outputs.                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| Separate monitoring cluster                                            | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Fleet-managed Elastic Agents, Standalone Elastic Agent and Beats can send to a remote monitoring cluster.                                                                                                                                                                                                                                                                                                                                                                                                                  |
| Secret management                                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                                                             | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | Elastic Agent stores credentials in the agent policy. Beats allows users to access credentials in a local [keystore](https://www.elastic.co/docs/reference/beats/filebeat/keystore).                                                                                                                                                                                                                                                                                                                                       |
| Progressive or canary deployments                                      | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)<applies-to>Elastic Stack: Generally available since 9.1</applies-to> | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | To upgrade Fleet-managed Elastic Agents progressively, you can [configure an automatic upgrade](/docs/reference/fleet/upgrade-elastic-agent#auto-upgrade-agents) in the Elastic Agent policy. <applies-to>Elastic Stack: Generally available since 9.1</applies-to>With standalone Elastic Agent and Beats you can deploy configuration files progressively using third party solutions.                                                                                                                                   |
| Multiple configurations per host                                       | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)(uses input conditions instead)                                              | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)(uses input conditions instead) | Elastic Agent uses a single Elastic Agent policy for configuration, and uses [variables and input conditions](https://www.elastic.co/docs/reference/fleet/dynamic-input-configuration) to adapt on a per-host basis. Beats supports multiple configuration files per host, enabling third party solutions to deploy files hierarchically or in multiple groups, and enabling finer-grained access control to those files.                                                                                                  |
| Compatible with version control and infrastructure as code solutions   | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)(only using API)                                                             | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg)                         | Agent policies created in the Fleet UI can't be managed with external version control or infrastructure as code solutions. However, you could develop a solution that [uses the Fleet API or adds a preconfigured policy to Kibana](https://www.elastic.co/docs/reference/fleet/create-policy-no-ui). Beats and Elastic Agent in standalone mode use a YAML file that is compatible with these solutions.                                                                                                                  |
| Spooling data to local disk                                            | ![yes](https://www.elastic.co/docs/reference/fleet/images/green-check.svg) | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                                                             | ![no](https://www.elastic.co/docs/reference/fleet/images/red-x.svg)                                | This feature is currently being [considered for development](https://github.com/elastic/elastic-agent/issues/3490).                                                                                                                                                                                                                                                                                                                                                                                                        |


## Elastic Agent monitoring support

You configure the collection of agent metrics in the agent policy. If metrics collection is selected (the default), all Elastic Agents enrolled in the policy will send metrics data to Elasticsearch (the output is configured globally).
The following image shows the **Agent monitoring** settings for the default agent policy:
![Screen capture of agent monitoring settings in the default agent policy](https://www.elastic.co/docs/reference/fleet/images/agent-monitoring-settings.png)

There are also pre-built dashboards for agent metrics that you can access under **Assets** in the Elastic Agent integration:
![Screen capture of Elastic Agent monitoring assets](https://www.elastic.co/docs/reference/fleet/images/agent-monitoring-assets.png)

The **[Elastic Agent] Agent metrics** dashboard shows an aggregated view of agent metrics:
![Screen capture showing Elastic Agent metrics](https://www.elastic.co/docs/reference/fleet/images/agent-metrics-dashboard.png)

For more information, refer to [Monitor Elastic Agents](https://www.elastic.co/docs/reference/fleet/monitor-elastic-agent).