﻿---
title: Alerting rule templates
description: Alerting rule templates are out-of-the-box alert definitions that come bundled with Elastic integrations, enabling users to quickly set up monitoring...
url: https://www.elastic.co/docs/reference/fleet/alerting-rule-templates
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Alerting rule templates
Alerting rule templates are out-of-the-box alert definitions that come bundled with [Elastic integrations](https://www.elastic.co/docs/reference/integrations), enabling users to quickly set up monitoring without writing queries from scratch.
Templates help you start monitoring in minutes by providing curated ES|QL queries and recommended thresholds tailored to each integration.
After the integration is installed, these templates are automatically available in Kibana's alerting interface with a prefilled rule creation form that you can adapt to your needs.
Although these templates are managed by Elastic, any alert created from them is owned by the customer and will not be modified by Elastic, even if the templates change.
<important>
  Although the alerts can be used as provided, threshold values should always be evaluated in the context of your specific environment. Depending on how you adjust the thresholds, you may either generate too many alerts or fail to trigger alerts when expected.
</important>


## Prerequisites

- Install or upgrade to the latest version of the integration that includes alerting rule templates.
- Ensure the data collection is enabled for the metrics or events that you plan to use.
- Elastic Stack 9.2.1 or later.
- Appropriate Kibana role privileges to create and manage rules.


## How to use the Alerting rule templates

Alerting rule templates come with recommended, pre-populated values. To use them:
1. In Kibana, go to **Management** > **Integrations**.
2. Find and open the integration.
3. On the integration page, open the **Assets** tab and expand **Alerting rule templates** to view all available templates for that integration.
   <note>
   You can find the Alerting rule template option only when the integration adds template support for alerting rules.
   </note>
4. Select a template to open a prefilled **Create rule** form.
   You can use the template to create your own custom alerting rule by adjusting values, setting up connectors, and defining rule actions.
5. Review and (optionally) customize the prefilled settings, then save and enable the rule.
   The rule created from the template gets listed in the **Observability** → **Alerts** → **Manage Rules** page.

To update the rule you have created from the template, go to **Observability** → **Alerts** → **Manage Rules**, select the rule and click **Actions**.
The preconfigured defaults include:
- <definitions>
  <definition term="ES|QL query">
  A curated, text-based query that evaluates your data and triggers when matches are found during the latest run.
  </definition>
  </definitions>
- <definitions>
  <definition term="Recommended threshold">
  A suggested threshold embedded in the ES|QL `WHERE` clause. You can tune the threshold to fit your environment.
  </definition>
  </definitions>
- <definitions>
  <definition term="Time window (look-back)">
  The length of time the rule analyzes for data (for example, the last 5 minutes).
  </definition>
  </definitions>
- <definitions>
  <definition term="Rule schedule">
  How frequently the rule checks alert conditions (for example, every minute).
  </definition>
  </definitions>
- <definitions>
  <definition term="Alert delay (alert suppression)">
  The number of consecutive runs for which conditions must be met before an alert is created.
  </definition>
  </definitions>

For details about fields in the Create rule form and how the rule evaluates data, refer to the [Elasticsearch query rule type](https://www.elastic.co/docs/explore-analyze/alerts-cases/alerts/rule-type-es-query).