﻿---
title: Elastic Agent built-in alerts
description: When you install or upgrade Elastic Agent, new alert rules are created automatically. You can configure and customize out-of-the-box alerts to get them...
url: https://www.elastic.co/docs/reference/fleet/alert-templates
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available since 9.2
---

# Elastic Agent built-in alerts
## Elastic Agent out-of-the-box alert rules

When you install or upgrade Elastic Agent, new alert rules are created automatically. You can configure and customize out-of-the-box alerts to get them up and running quickly.
<note>
  The built-in alerts feature for Elastic Agent is available only for some subscription levels. The license (or a trial license) must be in place _before_ you install or upgrade Elastic Agent for the alert rules to be available.Refer to [Elastic subscriptions](https://www.elastic.co/subscriptions) for more information.
</note>

In Kibana, you can enable out-of-the-box rules pre-configured with reasonable defaults to provide immediate value for managing agents.
You can use [ES|QL](https://www.elastic.co/docs/explore-analyze/discover/try-esql) to author conditions for each rule.
You can find these rules in **Stack Management** > **Alerts and Insights** > **Rules**.

### Available alert rules


| Alert                                  | Description                                                                                                                                                                                                                                                                              |
|----------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| [Elastic Agent] CPU usage spike        | Checks if Elastic Agent or any of its processes were pegged at a high CPU for a specified window of time. This could signal a bug in an application and warrant further investigation. - Condition: Alert on `system.process.cpu.total.time.ms` over 80% for 5 minutes- Default: Enabled |
| [Elastic Agent] Dropped events         | Checks ratio of dropped events to acknowledged events. Rows are distinguished by agent ID and component ID.  - Condition: Alert on ratio of dropped events to acked events of 5% or more- Default: Enabled                                                                               |
| [Elastic Agent] Excessive memory usage | Checks if Elastic Agent or any of its processes have a high memory usage or memory usage that is trending up. This could signal a memory leak in an application and warrant further investigation.- Condition: Alert on `system.process.memory.rss.pct` more than 50%- Default: Enabled  |
| [Elastic Agent] Excessive restarts     | Checks for excessive restarts on a host. Some restarts can have a business impact, and getting alerts for them can enable timely mitigation.- Condition: Alert on 11 or more restarts in a 5-minute window- Default: Enabled                                                             |
| [Elastic Agent] High pipeline queue    | Checks percentage of pipeline queue. Rows are distinguished by agent ID and component ID.  - Condition: Alert on max of `beat.stats.libbeat.pipeline.queue.filled.pct` exceeding 90%  - Default: Enabled                                                                                 |
| [Elastic Agent] Output errors          | Checks errors per minute from an agent component. Rows are distinguished by agent ID and component ID.  - Condition: Alert on 6 or more errors per minute  - Default: Enabled                                                                                                            |
| [Elastic Agent] Unhealthy status       | Checks agent status. An `unhealthy` status can indicate errors or degraded functionality of the agent.  - Condition: Alert on `unhealthy` status - Default: Enabled                                                                                                                      |

**Connectors** are not added to rules automatically, but you can attach a connector to route alerts to your Slack, email, or other notification platforms.
In addition, you can add filters for policies, tags, or hostnames to scope alerts to specific sets of agents.