﻿---
title: Elastic Agent environment variables
description: Use environment variables to configure Elastic Agent when running in a containerized environment. Variables on this page are grouped by action type: Common...
url: https://www.elastic.co/docs/reference/fleet/agent-environment-variables
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent environment variables
Use environment variables to configure Elastic Agent when running in a containerized environment. Variables on this page are grouped by action type:
- [Common variables](#env-common-vars)
- [Configure Kibana:](#env-prepare-kibana-for-fleet) prepare the Fleet plugin in Kibana
- <applies-to>Elastic Cloud Serverless: Unavailable</applies-to> [Configure Fleet Server:](#env-bootstrap-fleet-server) bootstrap Fleet Server on an Elastic Agent
- [Configure Elastic Agent and Fleet:](#env-enroll-agent) enroll an Elastic Agent


## Common variables

To limit the number of environment variables that need to be set, the following common variables are available. These variables can be used across all Elastic Agent actions, but have a lower precedence than action-specific environment variables.
These common variables are useful, for example, when using the same Elasticsearch and Kibana credentials to prepare the Fleet plugin in Kibana, configure Fleet Server, and enroll an Elastic Agent.

| Settings                 | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|--------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ELASTICSEARCH_HOST`     | (string) The Elasticsearch host to communicate with.**Default:** `http://elasticsearch:9200`                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| `ELASTICSEARCH_USERNAME` | (string) The basic authentication username used to connect to Kibana and retrieve a `service_token` for Fleet.**Default:** none                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `ELASTICSEARCH_PASSWORD` | (string) The basic authentication password used to connect to Kibana and retrieve a `service_token` for Fleet.**Default:** none                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| `ELASTICSEARCH_API_KEY`  | (string) API key used for authenticating to Elasticsearch.**Default:** none                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `ELASTICSEARCH_CA`       | (string) The path to a certificate authority.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `""`                                                                                                                                            |
| `KIBANA_HOST`            | (string) The Kibana host.**Default:** `http://kibana:5601`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `KIBANA_USERNAME`        | (string) The basic authentication username used to connect to Kibana to retrieve a `service_token`.**Default:** `elastic`                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `KIBANA_PASSWORD`        | (string) The basic authentication password used to connect to Kibana to retrieve a `service_token`.**Default:** `changeme`                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| `KIBANA_CA`              | (string) The path to a certificate authority.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `""`                                                                                                                                            |
| `ELASTIC_NETINFO`        | (bool) When `false`, disables `netinfo.enabled` parameter of `add_host_metadata` processor. Setting this to `false` is recommended for large scale setups where the host.ip and host.mac fields index size increases.By default, Elastic Agent initializes the `add_host_metadata` processor. The `netinfo.enabled` parameter defines ingestion of IP addresses and MAC addresses as fields `host.ip` and `host.mac`. For more information see [add_host_metadata](https://www.elastic.co/docs/reference/fleet/add_host_metadata-processor)**Default:** `"false"` |


## Prepare Kibana for Fleet

Settings used to prepare the Fleet plugin in Kibana.

| Settings                | Description                                                                                                                                                                                                                                                                                                                                                                                                                                            |
|-------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `KIBANA_FLEET_HOST`     | (string) The Kibana host to enable Fleet on. Overrides `FLEET_HOST` when set.**Default:** `http://kibana:5601`                                                                                                                                                                                                                                                                                                                                         |
| `KIBANA_FLEET_USERNAME` | (string) The basic authentication username used to connect to Kibana and retrieve a `service_token` to enable Fleet. Overrides `ELASTICSEARCH_USERNAME` when set.**Default:** `elastic`                                                                                                                                                                                                                                                                |
| `KIBANA_FLEET_PASSWORD` | (string) The basic authentication password used to connect to Kibana and retrieve a `service_token` to enable Fleet. Overrides `ELASTICSEARCH_PASSWORD` when set.**Default:** `changeme`                                                                                                                                                                                                                                                               |
| `KIBANA_FLEET_CA`       | (string) The path to a certificate authority. Overrides `KIBANA_CA` when set.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `""` |


## Bootstrap Fleet Server

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

Settings used to bootstrap Fleet Server on this Elastic Agent. At least one Fleet Server is required in a deployment.

| Settings                                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
|-----------------------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `FLEET_SERVER_ENABLE`                               | (int) Set to `1` to bootstrap Fleet Server on this Elastic Agent. When set to `1`, this automatically forces Fleet enrollment as well.**Default:** none                                                                                                                                                                                                                                                                                                       |
| `FLEET_SERVER_ELASTICSEARCH_HOST`                   | (string) The Elasticsearch host for Fleet Server to communicate with. Overrides `ELASTICSEARCH_HOST` when set.**Default:** `http://elasticsearch:9200`                                                                                                                                                                                                                                                                                                        |
| `FLEET_SERVER_ELASTICSEARCH_CA`                     | (string) The path to a certificate authority. Overrides `ELASTICSEARCH_CA` when set.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `""` |
| `FLEET_SERVER_ES_CERT`                              | (string) The path to the mutual TLS client certificate that Fleet Server will use to connect to Elasticsearch.**Default:** `""`                                                                                                                                                                                                                                                                                                                               |
| `FLEET_SERVER_ES_CERT_KEY`                          | (string) The path to the mutual TLS private key that Fleet Server will use to connect to Elasticsearch.**Default:** `""`                                                                                                                                                                                                                                                                                                                                      |
| `FLEET_SERVER_INSECURE_HTTP`                        | (bool) When `true`, Fleet Server is exposed over insecure or unverified HTTP. Setting this to `true` is not recommended.**Default:** `false`                                                                                                                                                                                                                                                                                                                  |
| `FLEET_SERVER_SERVICE_TOKEN`                        | (string) Service token to use for communication with Elasticsearch and Kibana if [`KIBANA_FLEET_SETUP`](#env-prepare-kibana-for-fleet) is enabled. If the service token value and service token path are specified the value may be used for setup and the path is passed to the agent in the container.**Default:** none                                                                                                                                     |
| `FLEET_SERVER_SERVICE_TOKEN_PATH`                   | (string) The path to the service token file to use for communication with Elasticsearch and Kibana if [`KIBANA_FLEET_SETUP`](#env-prepare-kibana-for-fleet) is enabled. If the service token value and service token path are specified the value may be used for setup and the path is passed to the agent in the container.**Default:** none                                                                                                                |
| `FLEET_SERVER_POLICY_NAME`                          | (string) The name of the policy for Fleet Server to use on itself. Overrides `FLEET_TOKEN_POLICY_NAME` when set.**Default:** none                                                                                                                                                                                                                                                                                                                             |
| `FLEET_SERVER_POLICY_ID`                            | (string) The policy ID for Fleet Server to use on itself.                                                                                                                                                                                                                                                                                                                                                                                                     |
| `FLEET_SERVER_HOST`                                 | (string) The binding host for Fleet Server HTTP. Overrides the host defined in the policy.**Default:** none                                                                                                                                                                                                                                                                                                                                                   |
| `FLEET_SERVER_PORT`                                 | (string) The binding port for Fleet Server HTTP. Overrides the port defined in the policy.**Default:** none                                                                                                                                                                                                                                                                                                                                                   |
| `FLEET_SERVER_CERT`                                 | (string) The path to the certificate to use for HTTPS.**Default:** none                                                                                                                                                                                                                                                                                                                                                                                       |
| `FLEET_SERVER_CERT_KEY`                             | (string) The path to the private key for the certificate used for HTTPS.**Default:** none                                                                                                                                                                                                                                                                                                                                                                     |
| `FLEET_SERVER_CERT_KEY_PASSPHRASE`                  | (string) The path to the private key passphrase for an encrypted private key file.**Default:** none                                                                                                                                                                                                                                                                                                                                                           |
| `FLEET_SERVER_CLIENT_AUTH`                          | (string) One of `none`, `optional`, or `required`. Fleet Server's client authentication option for client mTLS connections. If `optional` or `required` is specified, client certificates are verified using CAs.**Default:** `none`                                                                                                                                                                                                                          |
| `FLEET_SERVER_ELASTICSEARCH_CA_TRUSTED_FINGERPRINT` | (string) The SHA-256 fingerprint (hash) of the certificate authority used to self-sign Elasticsearch certificates. This fingerprint is used to verify self-signed certificates presented by Fleet Server and any inputs started by Elastic Agent for communication. This flag is required when using self-signed certificates with Elasticsearch.**Default:** `""`                                                                                            |
| `FLEET_DAEMON_TIMEOUT`                              | (duration) Set to indicate how long Fleet Server will wait during the bootstrap process for Elastic Agent.                                                                                                                                                                                                                                                                                                                                                    |
| `FLEET_SERVER_TIMEOUT`                              | (duration) Set to indicate how long Elastic Agent will wait for Fleet Server to check in as healthy.                                                                                                                                                                                                                                                                                                                                                          |


## Enroll Elastic Agent

Settings used to enroll an Elastic Agent into a Fleet Server.

| Settings                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
|-------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ELASTIC_AGENT_CERT`                | (string) The path to the mutual TLS client certificate that Elastic Agent will use to connect to Fleet Server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `ELASTIC_AGENT_CERT_KEY`            | (string) The path to the mutual TLS private key that Elastic Agent will use to connect to Fleet Server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `ELASTIC_AGENT_CERT_KEY_PASSPHRASE` | (string) The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server. The file must only contain the characters of the passphrase, no newline or extra non-printing characters.This option is only used if the `--elastic-agent-cert-key` is encrypted and requires a passphrase to use.                                                                                                                                                                                                                                                                                                                                                                                    |
| `ELASTIC_AGENT_ID`                  | (string) The unique identifier (agent ID) to use when enrolling the Elastic Agent with Fleet Server. This setting is useful when restoring a previously enrolled agent or in stateless containerized environments where the agent cannot persist enrollment data between redeployments.If an agent with the same ID is already enrolled in Fleet, enrollment will fail unless a valid replacement token is provided using the `FLEET_REPLACE_TOKEN` environment variable.**Default:** `""`                                                                                                                                                                                                                                                              |
| `ELASTIC_AGENT_TAGS`                | (string) A comma-separated list of tags to apply to Fleet-managed Elastic Agents. You can use these tags to filter the list of agents in Fleet.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `FLEET_ENROLL`                      | (bool) Set to `1` to enroll the Elastic Agent into Fleet Server.**Default:** `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| `FLEET_FORCE`                       | (bool) Set to `true` to force overwrite of the current Elastic Agent configuration without prompting for confirmation. This flag is helpful when using automation software or scripted deployments.**Default:** `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `FLEET_URL`                         | (string) URL to enroll the Fleet Server into.**Default:** `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `FLEET_ENROLLMENT_TOKEN`            | (string) The token to use for enrollment.**Default:** `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| `FLEET_REPLACE_TOKEN`               | (string) The token that can be used to replace the Elastic Agent after it is enrolled in Fleet Server. The `FLEET_REPLACE_TOKEN` environment variable must be provided when enrolling an agent with a specific agent ID for the first time. Subsequently, the agent can be replaced by enrolling another agent using the same `ELASTIC_AGENT_ID` and `FLEET_REPLACE_TOKEN` environment variables. Once replaced, the original agent can no longer communicate with Fleet.If an Elastic Agent is enrolled without a replacement token, it cannot be replaced by another agent with the same ID. This mechanism prevents accidental or malicious takeovers by requiring the replacement token to match the hashed token stored in Fleet.**Default:** `""` |
| `FLEET_TOKEN_NAME`                  | (string) The token name to use to fetch the token from Kibana.**Default:** `""`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| `FLEET_TOKEN_POLICY_NAME`           | (string) The token policy name to use to fetch the token from Kibana.**Default:** `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| `FLEET_CA`                          | (string) The path to a certificate authority. Overrides `ELASTICSEARCH_CA` when set.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `false`                                                                                                                                                                                                                                                                                        |
| `FLEET_INSECURE`                    | (bool) When `true`, Elastic Agent communicates with Fleet Server over insecure or unverified HTTP. Setting this to `true` is not recommended.**Default:** `false`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| `KIBANA_FLEET_HOST`                 | (string) The Kibana host to enable Fleet on. Overrides `FLEET_HOST` when set.**Default:** `http://kibana:5601`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| `KIBANA_FLEET_USERNAME`             | (string) The basic authentication username used to connect to Kibana and retrieve a `service_token` to enable Fleet. Overrides `ELASTICSEARCH_USERNAME` when set.**Default:** `elastic`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| `KIBANA_FLEET_PASSWORD`             | (string) The basic authentication password used to connect to Kibana and retrieve a `service_token` to enable Fleet. Overrides `ELASTICSEARCH_PASSWORD` when set.**Default:** `changeme`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| `KIBANA_FLEET_CA`                   | (string) The path to a certificate authority. Overrides `KIBANA_CA` when set.By default, Elastic Agent uses the list of trusted certificate authorities (CA) from the operating system where it is running. If the certificate authority that signed your node certificates is not in the host system’s trusted certificate authorities list, use this config to add the path to the `.pem` file that contains your CA’s certificate.**Default:** `""`                                                                                                                                                                                                                                                                                                  |