﻿---
title: Elastic Agent command reference
description: Elastic Agent provides commands for running Elastic Agent, managing Fleet Server, and doing common tasks. The commands listed here apply to both Fleet-managed...
url: https://www.elastic.co/docs/reference/fleet/agent-command-reference
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elastic Agent command reference
Elastic Agent provides commands for running Elastic Agent, managing Fleet Server, and doing common tasks. The commands listed here apply to both [Fleet-managed](https://www.elastic.co/docs/reference/fleet/manage-elastic-agents-in-fleet) and [standalone](https://www.elastic.co/docs/reference/fleet/configure-standalone-elastic-agents) Elastic Agent.
<admonition title="Restrictions">
  Note the following restrictions for running Elastic Agent commands:
  - You might need to log in as a root user (or Administrator on Windows) to run the commands described here. After the Elastic Agent service is installed and running, make sure you run these commands without prepending them with `./` to avoid invoking the wrong binary.
  - Running Elastic Agent commands using the Windows PowerShell ISE is not supported.
</admonition>

<admonition title="Command options for Fleet Server" applies-to="Elastic Cloud Serverless: Unavailable">
  Because self-managed Fleet Server is not supported on Elastic Cloud Serverless, the `elastic-agent enroll` and `elastic-agent install` options that configure Fleet Server are not available on Serverless.
</admonition>

- [diagnostics](#elastic-agent-diagnostics-command)
- [enroll](#elastic-agent-enroll-command)
- [help](#elastic-agent-help-command)
- [inspect](#elastic-agent-inspect-command)
- [install](#elastic-agent-install-command)
- [otel](#elastic-agent-otel-command)
- [privileged](#elastic-agent-privileged-command)
- [restart](#elastic-agent-restart-command)
- [run](#elastic-agent-run-command)
- [status](#elastic-agent-status-command)
- [uninstall](#elastic-agent-uninstall-command)
- [upgrade](#elastic-agent-upgrade-command)
- [logs](#elastic-agent-logs-command)
- [unprivileged](#elastic-agent-unprivileged-command)
- [version](#elastic-agent-version-command)


## elastic-agent diagnostics

Gather diagnostics information from the Elastic Agent and component/unit it’s running. This command produces an archive that contains:
- version.txt - version information
- agent-info.yaml - contains the agent local metadata that is also sent to Fleet
- pre-config.yaml - pre-configuration before variable substitution - this is the elastic-agent.yaml from disk or from Fleet
- otel.yaml - the OpenTelemetry collector configuration file used with the `otel` sub-command
- otel-merged.yaml - the final configuration file provided to the OpenTelemetry collector, including any internally generated collector components
- variables.yaml - current variable contexts from providers
- environment.yaml - current environment variables visible to the Elastic Agent process
- computed-config.yaml - configuration after variable substitution
- components-expected.yaml - expected computed components model from the computed-config.yaml
- components-actual.yaml - actual running components model as reported by the runtime manager
- state.yaml - current state information of all running components
- *.pprof.gz files from the running `elastic-agent` process for analysis with `go tool pprof`:
  - goroutine.pprof.gz - goroutine dump
- heap.pprof.gz - memory allocation of live objects
- allocs.pprof.gz - sampling past memory allocations
- threadcreate.pprof.gz - traces led to creation of new OS threads
- block.pprof.gz - stack traces that led to blocking on synchronization primitives
- mutex.pprof.gz - stack traces of holders of contended mutexes
- components/ directory - diagnostic information from each running component process:
  - Typically one directory per input-output pair representing a supervised process containing:
  - *.pprof.gz - profiles for analysis with `go tool pprof`; refer to the previous descriptions
- *_metrics.json - metrics snapshots captured from running Beat processes
- edot/ directory - the output of Elastic's collector diagnostics extension:
  - otel-merged-actual.yaml - the current configuration of the running collector, which should match the otel-merged.yaml file described previously
- *.profile.gz - profiles for analysis with `go tool pprof`; refer to the previous descriptions

Note that **credentials may not be redacted** in the archive; they may appear in plain text in the configuration or policy files inside the archive.
This command is intended for debugging purposes only. The output format and structure of the archive may change between releases.

### Synopsis

```shell
elastic-agent diagnostics [--file <string>]
                          [--cpu-profile]
                          [--exclude-events]
                          [--help]
                          [global-flags]
```


### Options

<definitions>
  <definition term="--file">
    Specifies the output archive name. Defaults to `elastic-agent-diagnostics-<timestamp>.zip`, where the timestamp is the current time in UTC.
  </definition>
  <definition term="--help">
    Show help for the `diagnostics` command.
  </definition>
  <definition term="--cpu-profile">
    Additionally runs a 30-second CPU profile on each running component. This will generate an additional `cpu.pprof` file for each component.
  </definition>
  <definition term="--p">
    Alias for `--cpu-profile`.
  </definition>
  <definition term="--exclude-events">
    Exclude the events log files from the diagnostics archive.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Example

```shell
elastic-agent diagnostics
```


## elastic-agent enroll

Enroll the Elastic Agent in Fleet.
Use this command to enroll the Elastic Agent in Fleet without installing the agent as a service. You will need to do this if you installed the Elastic Agent from a DEB or RPM package and plan to use systemd commands to start and manage the service. This command is also useful for testing Elastic Agent prior to installing it.
If you’ve already installed Elastic Agent, use this command to modify the settings that Elastic Agent runs with.
<tip>
  To enroll an Elastic Agent *and* install it as a service, use the [`install` command](#elastic-agent-install-command) instead. Installing as a service is the most common scenario.
</tip>

We recommend that you run the `enroll` (or `install`) command as the root user because some integrations require root privileges to collect sensitive data. This command overwrites the `elastic-agent.yml` file in the agent directory.
This command includes optional flags to set up [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server).
<important>
  This command enrolls the Elastic Agent in Fleet; it does not start the agent. To start the agent, either [start the service](/docs/reference/fleet/start-stop-elastic-agent#start-elastic-agent-service), if one exists, or use the [`run` command](#elastic-agent-run-command) to start the agent from a terminal.
</important>


### Synopsis

To enroll the Elastic Agent in Fleet:
```shell
elastic-agent enroll --url <string>
                     --enrollment-token <string>
                     [--ca-sha256 <string>]
                     [--certificate-authorities <string>]
                     [--daemon-timeout <duration>]
                     [--delay-enroll]
                     [--elastic-agent-cert <string>]
                     [--elastic-agent-cert-key <string>]
                     [--elastic-agent-cert-key-passphrase <string>]
                     [--force]
                     [--header <strings>]
                     [--help]
                     [--id <string>]
                     [--insecure ]
                     [--proxy-disabled]
                     [--proxy-header <strings>]
                     [--proxy-url <string>]
                     [--replace-token <string>]
                     [--staging <string>]
                     [--tag <string>]
                     [global-flags]
```

To enroll the Elastic Agent in Fleet and set up Fleet Server:
```shell
elastic-agent enroll --fleet-server-es <string>
                     --fleet-server-service-token <string>
                     [--fleet-server-service-token-path <string>]
                     [--ca-sha256 <string>]
                     [--certificate-authorities <string>]
                     [--daemon-timeout <duration>]
                     [--delay-enroll]
                     [--elastic-agent-cert <string>]
                     [--elastic-agent-cert-key <string>]
                     [--elastic-agent-cert-key-passphrase <string>]
                     [--fleet-server-cert <string>] 
                     [--fleet-server-cert-key <string>]
                     [--fleet-server-cert-key-passphrase <string>]
                     [--fleet-server-client-auth <string>]
                     [--fleet-server-es-ca <string>]
                     [--fleet-server-es-ca-trusted-fingerprint <string>] 
                     [--fleet-server-es-cert <string>]
                     [--fleet-server-es-cert-key <string>]
                     [--fleet-server-es-insecure]
                     [--fleet-server-host <string>]
                     [--fleet-server-policy <string>]
                     [--fleet-server-port <uint16>]
                     [--fleet-server-timeout <duration>]
                     [--force]
                     [--header <strings>]
                     [--help]
                     [--proxy-disabled]
                     [--proxy-header <strings>]
                     [--proxy-url <string>]
                     [--staging <string>]
                     [--tag <string>]
                     [--url <string>] 
                     [global-flags]
```

For more information about custom certificates, refer to [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections).

### Options

<definitions>
  <definition term="--ca-sha256 <string>">
    Comma-separated list of certificate authority hash pins used for certificate verification.
  </definition>
  <definition term="--certificate-authorities <string>">
    Comma-separated list of root certificates used for server verification.
  </definition>
  <definition term="--daemon-timeout <duration>">
    Timeout waiting for Elastic Agent daemon.
  </definition>
  <definition term="--delay-enroll">
    Delays enrollment to occur on first start of the Elastic Agent service. This setting is useful when you don’t want the Elastic Agent to enroll until the next reboot or manual start of the service, for example, when you’re preparing an image that includes Elastic Agent.
  </definition>
  <definition term="--elastic-agent-cert">
    Certificate to use as the client certificate for the Elastic Agent's connections to Fleet Server.
  </definition>
  <definition term="--elastic-agent-cert-key">
    Private key to use as for the Elastic Agent's connections to Fleet Server.
  </definition>
  <definition term="--elastic-agent-cert-key-passphrase">
    The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server. The file must only contain the characters of the passphrase, no newline or extra non-printing characters.
    This option is only used if the `--elastic-agent-cert-key` is encrypted and requires a passphrase to use.
  </definition>
  <definition term="--enrollment-token <string>">
    Enrollment token to use to enroll Elastic Agent into Fleet. You can use the same enrollment token for multiple agents.
  </definition>
  <definition term="--fleet-server-cert <string> Elastic Cloud Serverless: Unavailable">
    Certificate to use for exposed Fleet Server HTTPS endpoint.
  </definition>
  <definition term="--fleet-server-cert-key <string> Elastic Cloud Serverless: Unavailable">
    Private key to use for exposed Fleet Server HTTPS endpoint.
  </definition>
  <definition term="--fleet-server-cert-key-passphrase <string> Elastic Cloud Serverless: Unavailable">
    Path to passphrase file for decrypting Fleet Server's private key if an encrypted private key is used.
  </definition>
  <definition term="--fleet-server-client-auth <string> Elastic Cloud Serverless: Unavailable">
    One of `none`, `optional`, or `required`. Defaults to `none`. Fleet Server's `client_authentication` option for client mTLS connections. If `optional`, or `required` is specified, client certificates are verified using CAs specified in the `--certificate-authorities` flag.
  </definition>
  <definition term="--fleet-server-es <string> Elastic Cloud Serverless: Unavailable">
    Start a Fleet Server process when Elastic Agent is started, and connect to the specified Elasticsearch URL.
  </definition>
  <definition term="--fleet-server-es-ca <string> Elastic Cloud Serverless: Unavailable">
    Path to certificate authority to use to communicate with Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-ca-trusted-fingerprint <string> Elastic Cloud Serverless: Unavailable">
    The SHA-256 fingerprint (hash) of the certificate authority used to self-sign Elasticsearch certificates. This fingerprint will be used to verify self-signed certificates presented by Fleet Server and any inputs started by Elastic Agent for communication. This flag is required when using self-signed certificates with Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-cert Elastic Cloud Serverless: Unavailable">
    The path to the client certificate that Fleet Server will use when connecting to Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-cert-key Elastic Cloud Serverless: Unavailable">
    The path to the private key that Fleet Server will use when connecting to Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-insecure Elastic Cloud Serverless: Unavailable">
    Allows fleet server to connect to Elasticsearch in the following situations:
    - When connecting to an HTTP server.
    - When connecting to an HTTPs server and the certificate chain cannot be verified. The content is encrypted, but the certificate is not verified.
    When this flag is used the certificate verification is disabled.
  </definition>
  <definition term="--fleet-server-host <string> Elastic Cloud Serverless: Unavailable">
    Fleet Server HTTP binding host (overrides the policy).
  </definition>
  <definition term="--fleet-server-policy <string> Elastic Cloud Serverless: Unavailable">
    Used when starting a self-managed Fleet Server to allow a specific policy to be used.
  </definition>
  <definition term="--fleet-server-port <uint16> Elastic Cloud Serverless: Unavailable">
    Fleet Server HTTP binding port (overrides the policy).
  </definition>
  <definition term="--fleet-server-service-token <string> Elastic Cloud Serverless: Unavailable">
    Service token to use for communication with Elasticsearch. Mutually exclusive with `--fleet-server-service-token-path`.
  </definition>
  <definition term="--fleet-server-service-token-path <string> Elastic Cloud Serverless: Unavailable">
    Service token file to use for communication with Elasticsearch. Mutually exclusive with `--fleet-server-service-token`.
  </definition>
  <definition term="--fleet-server-timeout <duration> Elastic Cloud Serverless: Unavailable">
    Timeout waiting for Fleet Server to be ready to start enrollment.
  </definition>
  <definition term="--force">
    Force overwrite of current configuration without prompting for confirmation. This flag is helpful when using automation software or scripted deployments.
    <note>
      If the Elastic Agent is already installed on the host, using `--force` may result in unpredictable behavior with duplicate Elastic Agents appearing in Fleet.
    </note>
  </definition>
  <definition term="--header <strings>">
    Headers used in communication with elasticsearch.
  </definition>
  <definition term="--help">
    Show help for the `enroll` command.
  </definition>
  <definition term="--id <string>">
    Specifies the unique identifier (agent ID) to use when enrolling the Elastic Agent with Fleet Server. This setting is useful when restoring a previously enrolled agent or in stateless environments where the agent cannot persist enrollment data between redeployments.
    <note>
      If an agent with the same ID is already enrolled in Fleet, enrollment will fail unless a valid replacement token is provided using the `--replace-token` flag.
    </note>
  </definition>
  <definition term="--insecure">
    Allow the Elastic Agent to connect to Fleet Server over insecure connections. This setting is required in the following situations:
    - When connecting to an HTTP server. The API keys are sent in clear text.
    - When connecting to an HTTPs server and the certificate chain cannot be verified. The content is encrypted, but the certificate is not verified.
    - When using self-signed certificates generated by Elastic Agent.
    We strongly recommend that you use a secure connection.
  </definition>
  <definition term="--proxy-disabled">
    Disable proxy support including environment variables.
  </definition>
  <definition term="--proxy-header <strings>">
    Proxy headers used with CONNECT request.
  </definition>
  <definition term="--proxy-url <string>">
    Configures the proxy URL.
  </definition>
  <definition term="--replace-token <string>">
    Specifies a token that can be used to replace the Elastic Agent after its enrollment in Fleet Server. The token must be provided when enrolling an agent with a specific agent ID for the first time. Subsequently, the agent can be replaced by enrolling another agent using the same agent ID and replacement token. Once replaced, the original agent can no longer communicate with Fleet.
    <note>
      If an Elastic Agent is enrolled without a replacement token, it cannot be replaced by another agent with the same ID. This mechanism prevents accidental or malicious takeovers by requiring the replacement token to match the hashed token stored in Fleet.
    </note>
  </definition>
  <definition term="--staging <string>">
    Configures agent to download artifacts from a staging build.
  </definition>
  <definition term="--tag <string>">
    A comma-separated list of tags to apply to Fleet-managed Elastic Agents. You can use these tags to filter the list of agents in Fleet.
    <note>
      Currently, there is no way to remove or edit existing tags. To change the tags, you must unenroll the Elastic Agent, then re-enroll it using new tags.
    </note>
  </definition>
  <definition term="--url <string>">
    Fleet Server URL to use to enroll the Elastic Agent into Fleet.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

Enroll the Elastic Agent in Fleet:
```shell
elastic-agent enroll \
  --url=https://cedd4e0e21e240b4s2bbbebdf1d6d52f.fleet.eu-west-1.aws.cld.elstc.co:443 \
  --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ==
```

Enroll the Elastic Agent in Fleet and set up Fleet Server:
```shell
elastic-agent enroll --fleet-server-es=http://elasticsearch:9200 \
  --fleet-server-service-token=AbEAAdesYXN1abMvZmxlZXQtc2VldmVyL3Rva2VuLTE2MTkxMzg3MzIzMTg7dzEta0JDTmZUcGlDTjlwRmNVTjNVQQ \
  --fleet-server-policy=a35fd520-26f5-11ec-8bd9-3374690g57b6
```

Start Elastic Agent with Fleet Server (running on a custom CA). This example assumes you’ve generated the certificates with the following names:
- `ca.crt`: Root CA certificate
- `fleet-server.crt`: Fleet Server certificate
- `fleet-server.key`: Fleet Server private key
- `elasticsearch-ca.crt`: CA certificate to use to connect to Elasticsearch

```shell
elastic-agent enroll \
  --url=https://fleet-server:8220 \
  --fleet-server-es=https://elasticsearch:9200 \
  --fleet-server-service-token=AAEBAWVsYXm0aWMvZmxlZXQtc2XydmVyL3Rva2VuLTE2MjM4OTAztDU1OTQ6dllfVW1mYnFTVjJwTC2ZQ0EtVnVZQQ \
  --fleet-server-policy=a35fd520-26f5-11ec-8bd9-3374690g57b6 \
  --certificate-authorities=/path/to/ca.crt \
  --fleet-server-es-ca=/path/to/elasticsearch-ca.crt \
  --fleet-server-cert=/path/to/fleet-server.crt \
  --fleet-server-cert-key=/path/to/fleet-server.key \
  --fleet-server-port=8220
```

Then enroll another Elastic Agent into the Fleet Server started in the previous example:
```shell
elastic-agent enroll --url=https://fleet-server:8220 \
  --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ== \
  --certificate-authorities=/path/to/ca.crt
```

Replace an Elastic Agent enrolled in Fleet Server with a specific agent ID and a replacement token:
```shell
elastic-agent enroll \
  --url=https://fleet-server:8220 \
  --enrollment-token=ENROLLMENT_TOKEN_HASH \
  --id=MY_AGENT_ID \
  --replace-token=REPLACEMENT_TOKEN_HASH
```


## elastic-agent help

Show help for a specific command.

### Synopsis

```shell
elastic-agent help <command> [--help] [global-flags]
```


### Options

<definitions>
  <definition term="command">
    The name of the command.
  </definition>
  <definition term="--help">
    Show help for the `help` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Example

```shell
elastic-agent help enroll
```


## elastic-agent inspect

Show the current Elastic Agent configuration. Use this command to verify and troubleshoot the configuration that Elastic Agent is using, including variable substitution and the computed components model.
If no flags are specified, the command shows the full Elastic Agent configuration. By default, variable substitution is not performed, and the raw configuration is displayed.
Use the `--variables` flag to enable variable substitution. The first set of computed variables are used when only the `--variables` flag is defined. This can prevent some of the dynamic providers like Kubernetes and Docker from providing all the possible variables they could have discovered if given more time. Use the `--variables-wait` flag to specify an amount of time to wait for variable discovery before using the variables for the configuration.
Use the `components` subcommand to view the components model. Components represent individual processes running underneath Elastic Agent, such as Filebeat or Endpoint Security. Units represent discrete configuration units within a component, such as Filebeat inputs or Metricbeat modules.

### Synopsis

```shell
elastic-agent inspect [--variables]
                      [--monitoring]
                      [--variables-wait <duration>]
                      [--help]
                      [global-flags]
elastic-agent inspect components [--show-config]
                                 [--show-spec]
                                 [--variables-wait <duration>]
                                 [--help]
                                 [<component_id>]
                                 [<component_id>/<unit_id>]
```


### Available commands

<definitions>
  <definition term="components">
    Display the generated components model for the current configuration. Variable substitution is always performed when computing the components model and cannot be disabled. By default, only the first set of computed variables are used. Use the `--variables-wait` flag to allow more time for dynamic providers to discover variables.
    This command accepts the following arguments and flags:
    <definitions>
      <definition term="<component_id>">
        Select a specific component by its ID. Only that component and all its units are returned. Use `elastic-agent inspect components` without an ID to see all available component IDs. Configuration for units is not shown by default; use `--show-config` to display it.
      </definition>
      <definition term="<component_id>/<unit_id>">
        Select a specific unit inside a component by specifying both the component ID and unit ID separated by a forward slash. In this mode, the unit configuration is shown by default.
      </definition>
      <definition term="--show-config">
        Display the configuration for all units. By default, unit configuration is hidden unless you select a specific unit using the `<component_id>/<unit_id>` format.
      </definition>
      <definition term="--show-spec">
        Display the input/output runtime specification for a component. By default, the runtime specification is hidden.
      </definition>
      <definition term="--variables-wait <duration>">
        Wait the specified amount of time for variable discovery before computing the components model. This is useful when using dynamic providers like Kubernetes or Docker that may need additional time to discover all available variables.
      </definition>
    </definitions>
  </definition>
</definitions>


### Options

<definitions>
  <definition term="--variables">
    Render the configuration with variables substituted. When not specified, the raw configuration is displayed without variable substitution.
  </definition>
  <definition term="--monitoring">
    Include the monitoring configuration in the output. This option implies `--variables`, as the monitoring configuration requires variable substitution.
  </definition>
  <definition term="--variables-wait <duration>">
    Wait the specified amount of time for variable discovery before performing substitution. This is useful when using dynamic providers like Kubernetes or Docker that may need additional time to discover all available variables. Implies `--variables`. For example, `--variables-wait 30s`.
  </definition>
  <definition term="--help">
    Show help for the `inspect` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

Show the raw Elastic Agent configuration without variable substitution:
```shell
elastic-agent inspect
```

Show the configuration with variables substituted:
```shell
elastic-agent inspect --variables
```

Show the configuration with variables substituted, waiting 30 seconds for dynamic providers to discover variables:
```shell
elastic-agent inspect --variables-wait 30s
```

Show the configuration including monitoring settings:
```shell
elastic-agent inspect --monitoring
```

Display all components:
```shell
elastic-agent inspect components
```

Display all components with their unit configurations:
```shell
elastic-agent inspect components --show-config
```

Display a specific component by ID:
```shell
elastic-agent inspect components log-default
```

Display a specific component with its runtime specification:
```shell
elastic-agent inspect components log-default --show-spec
```

Display a specific unit inside a component:
```shell
elastic-agent inspect components log-default/log-default
```

Wait 30 seconds for dynamic providers before computing components:
```shell
elastic-agent inspect components --variables-wait 30s
```


## elastic-agent privileged

Run Elastic Agent with full superuser privileges. This is the usual, default running mode for Elastic Agent. The `privileged` command allows you to switch back to running an agent with full administrative privileges when you have been running it in `unprivileged` mode.
Refer to [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged) for more detail.

### Examples

```shell
elastic-agent privileged
```


## elastic-agent install

Install Elastic Agent permanently on the system and manage it by using the system’s service manager. The agent will start automatically after installation is complete. On Linux (tar package), this command requires a system and service manager like systemd.
<important>
  If you installed Elastic Agent from a DEB or RPM package, the `install` command will skip the installation itself and function as an alias of the [`enroll` command](#elastic-agent-enroll-command) instead. After an upgrade of the Elastic Agent using DEB or RPM the Elastic Agent service needs to be restarted.
</important>

You must run this command as the root user (or Administrator on Windows) to write files to the correct locations. This command overwrites the `elastic-agent.yml` file in the agent directory.
The syntax for running this command varies by platform. As well, various flavors of the agent install package are available, allowing you to control the installed package size on disk and the set of included components. For platform-specific examples and for details about the available flavors, refer to [*Install Elastic Agents*](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).

### Synopsis

To install the Elastic Agent as a service, enroll it in Fleet, and start the `elastic-agent` service:
```shell
elastic-agent install --url <string>
                      --enrollment-token <string>
                      [--base-path <string>]
                      [--ca-sha256 <string>]
                      [--certificate-authorities <string>]
                      [--daemon-timeout <duration>]
                      [--delay-enroll]
                      [--elastic-agent-cert <string>]
                      [--elastic-agent-cert-key <string>]
                      [--elastic-agent-cert-key-passphrase <string>]
                      [--force]
                      [--header <strings>]
                      [--help]
                      [--insecure ]
                      [--non-interactive]
                      [--privileged]
                      [--proxy-disabled]
                      [--proxy-header <strings>]
                      [--proxy-url <string>]
                      [--staging <string>]
                      [--tag <string>]
                      [--unprivileged]
                      [global-flags]
```

To install the Elastic Agent as a service, enroll it in Fleet, and start a `fleet-server` process alongside the `elastic-agent` service:
```shell
elastic-agent install --fleet-server-es <string>
                      --fleet-server-service-token <string>
                      [--fleet-server-service-token-path <string>]
                      [--base-path <string>]
                      [--ca-sha256 <string>]
                      [--certificate-authorities <string>]
                      [--daemon-timeout <duration>]
                      [--delay-enroll]
                      [--elastic-agent-cert <string>]
                      [--elastic-agent-cert-key <string>]
                      [--elastic-agent-cert-key-passphrase <string>]
                      [--fleet-server-cert <string>] 
                      [--fleet-server-cert-key <string>]
                      [--fleet-server-cert-key-passphrase <string>]
                      [--fleet-server-client-auth <string>]
                      [--fleet-server-es-ca <string>]
                      [--fleet-server-es-ca-trusted-fingerprint <string>] 
                      [--fleet-server-es-cert <string>]
                      [--fleet-server-es-cert-key <string>]
                      [--fleet-server-es-insecure]
                      [--fleet-server-host <string>]
                      [--fleet-server-policy <string>]
                      [--fleet-server-port <uint16>]
                      [--fleet-server-timeout <duration>]
                      [--force]
                      [--header <strings>]
                      [--help]
                      [--non-interactive]
                      [--privileged]
                      [--proxy-disabled]
                      [--proxy-header <strings>]
                      [--proxy-url <string>]
                      [--staging <string>]
                      [--tag <string>]
                      [--unprivileged]
                      [--url <string>] 
                      [global-flags]
```

For more information about custom certificates, refer to [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections).

### Options

<definitions>
  <definition term="--base-path <string>">
    Install Elastic Agent in a location other than the [default](https://www.elastic.co/docs/reference/fleet/installation-layout). Specify the custom base path for the install.
    The `--base-path` option is not currently supported with [Elastic Defend](https://www.elastic.co/docs/solutions/security/configure-elastic-defend/install-elastic-defend).
  </definition>
  <definition term="--ca-sha256 <string>">
    Comma-separated list of certificate authority hash pins used for certificate verification.
  </definition>
  <definition term="--certificate-authorities <string>">
    Comma-separated list of root certificates used for server verification.
  </definition>
  <definition term="--daemon-timeout <duration>">
    Timeout waiting for Elastic Agent daemon.
  </definition>
  <definition term="--delay-enroll">
    Delays enrollment to occur on first start of the Elastic Agent service. This setting is useful when you don’t want the Elastic Agent to enroll until the next reboot or manual start of the service, for example, when you’re preparing an image that includes Elastic Agent.
  </definition>
  <definition term="--elastic-agent-cert">
    Certificate to use as the client certificate for the Elastic Agent's connections to Fleet Server.
  </definition>
  <definition term="--elastic-agent-cert-key">
    Private key to use as for the Elastic Agent's connections to Fleet Server.
  </definition>
  <definition term="--elastic-agent-cert-key-passphrase">
    The path to the file that contains the passphrase for the mutual TLS private key that Elastic Agent will use to connect to Fleet Server. The file must only contain the characters of the passphrase, no newline or extra non-printing characters.
    This option is only used if the `--elastic-agent-cert-key` is encrypted and requires a passphrase to use.
  </definition>
  <definition term="--enrollment-token <string>">
    Enrollment token to use to enroll Elastic Agent into Fleet. You can use the same enrollment token for multiple agents.
  </definition>
  <definition term="--fleet-server-cert <string> Elastic Cloud Serverless: Unavailable">
    Certificate to use for exposed Fleet Server HTTPS endpoint.
  </definition>
  <definition term="--fleet-server-cert-key <string> Elastic Cloud Serverless: Unavailable">
    Private key to use for exposed Fleet Server HTTPS endpoint.
  </definition>
  <definition term="--fleet-server-cert-key-passphrase <string> Elastic Cloud Serverless: Unavailable">
    Path to passphrase file for decrypting Fleet Server's private key if an encrypted private key is used.
  </definition>
  <definition term="--fleet-server-client-auth <string> Elastic Cloud Serverless: Unavailable">
    One of `none`, `optional`, or `required`. Defaults to `none`. Fleet Server's `client_authentication` option for client mTLS connections. If `optional`, or `required` is specified, client certificates are verified using CAs specified in the `--certificate-authorities` flag.
  </definition>
  <definition term="--fleet-server-es <string> Elastic Cloud Serverless: Unavailable">
    Start a Fleet Server process when Elastic Agent is started, and connect to the specified Elasticsearch URL.
  </definition>
  <definition term="--fleet-server-es-ca <string> Elastic Cloud Serverless: Unavailable">
    Path to certificate authority to use to communicate with Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-ca-trusted-fingerprint <string> Elastic Cloud Serverless: Unavailable">
    The SHA-256 fingerprint (hash) of the certificate authority used to self-sign Elasticsearch certificates. This fingerprint will be used to verify self-signed certificates presented by Fleet Server and any inputs started by Elastic Agent for communication. This flag is required when using self-signed certificates with Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-cert Elastic Cloud Serverless: Unavailable">
    The path to the client certificate that Fleet Server will use when connecting to Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-cert-key Elastic Cloud Serverless: Unavailable">
    The path to the private key that Fleet Server will use when connecting to Elasticsearch.
  </definition>
  <definition term="--fleet-server-es-insecure Elastic Cloud Serverless: Unavailable">
    Allows fleet server to connect to Elasticsearch in the following situations:
    - When connecting to an HTTP server.
    - When connecting to an HTTPs server and the certificate chain cannot be verified. The content is encrypted, but the certificate is not verified.
    When this flag is used the certificate verification is disabled.
  </definition>
  <definition term="--fleet-server-host <string> Elastic Cloud Serverless: Unavailable">
    Fleet Server HTTP binding host (overrides the policy).
  </definition>
  <definition term="--fleet-server-policy <string> Elastic Cloud Serverless: Unavailable">
    Used when starting a self-managed Fleet Server to allow a specific policy to be used.
  </definition>
  <definition term="--fleet-server-port <uint16> Elastic Cloud Serverless: Unavailable">
    Fleet Server HTTP binding port (overrides the policy).
  </definition>
  <definition term="--fleet-server-service-token <string> Elastic Cloud Serverless: Unavailable">
    Service token to use for communication with Elasticsearch. Mutually exclusive with `--fleet-server-service-token-path`.
  </definition>
  <definition term="--fleet-server-service-token-path <string> Elastic Cloud Serverless: Unavailable">
    Service token file to use for communication with Elasticsearch. Mutually exclusive with `--fleet-server-service-token`.
  </definition>
  <definition term="--fleet-server-timeout <duration> Elastic Cloud Serverless: Unavailable">
    Timeout waiting for Fleet Server to be ready to start enrollment.
  </definition>
  <definition term="--force">
    Force overwrite of current configuration without prompting for confirmation. This flag is helpful when using automation software or scripted deployments.
    <note>
      If the Elastic Agent is already installed on the host, using `--force` may result in unpredictable behavior with duplicate Elastic Agents appearing in Fleet.
    </note>
  </definition>
  <definition term="--header <strings>">
    Headers used in communication with elasticsearch.
  </definition>
  <definition term="--help">
    Show help for the `enroll` command.
  </definition>
  <definition term="--insecure">
    Allow the Elastic Agent to connect to Fleet Server over insecure connections. This setting is required in the following situations:
    - When connecting to an HTTP server. The API keys are sent in clear text.
    - When connecting to an HTTPs server and the certificate chain cannot be verified. The content is encrypted, but the certificate is not verified.
    - When using self-signed certificates generated by Elastic Agent.
    We strongly recommend that you use a secure connection.
  </definition>
  <definition term="--non-interactive">
    Install Elastic Agent in a non-interactive mode. This flag is helpful when using automation software or scripted deployments. If Elastic Agent is already installed on the host, the installation will terminate.
  </definition>
  <definition term="--privileged">
    Run Elastic Agent with full superuser privileges. This is the usual, default running mode for Elastic Agent. The `--privileged` option allows you to switch back to running an agent with full administrative privileges when you have been running it in `unprivileged`.
  </definition>
</definitions>

See the `--unprivileged` option and [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged) for more detail.
<definitions>
  <definition term="--proxy-disabled">
    Disable proxy support including environment variables.
  </definition>
  <definition term="--proxy-header <strings>">
    Proxy headers used with CONNECT request.
  </definition>
  <definition term="--proxy-url <string>">
    Configures the proxy URL.
  </definition>
  <definition term="--staging <string>">
    Configures agent to download artifacts from a staging build.
  </definition>
  <definition term="--tag <strings>">
    A comma-separated list of tags to apply to Fleet-managed Elastic Agents. You can use these tags to filter the list of agents in Fleet.
    <note>
      Currently, there is no way to remove or edit existing tags. To change the tags, you must unenroll the Elastic Agent, then re-enroll it using new tags.
    </note>
  </definition>
  <definition term="--unprivileged">
    Run Elastic Agent without full superuser privileges. This option is useful in organizations that limit `root` access on Linux or macOS systems, or `admin` access on Windows systems. For details and limitations for running Elastic Agent in this mode, refer to [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged).
    Changing to `unprivileged` mode is prevented if the agent is currently enrolled in a policy that includes an integration that requires administrative access, such as the Elastic Defend integration.
    <applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> To run Elastic Agent without superuser privileges as a pre-existing user or group, for instance under an Active Directory account, you can specify the user or group, and the password to use.
    For example:
    ```shell
    elastic-agent install --unprivileged  --user="my.path\username" --password="mypassword"
    ```
    ```shell
    elastic-agent install --unprivileged  --group="my.path\groupname" --password="mypassword"
    ```
  </definition>
  <definition term="--url <string>">
    Fleet Server URL to use to enroll the Elastic Agent into Fleet.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

Install the Elastic Agent as a service, enroll it in Fleet, and start the `elastic-agent` service:
```shell
elastic-agent install \
  --url=https://cedd4e0e21e240b4s2bbbebdf1d6d52f.fleet.eu-west-1.aws.cld.elstc.co:443 \
  --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ==
```

Install the Elastic Agent as a service, enroll it in Fleet, and start a `fleet-server` process alongside the `elastic-agent` service:
```shell
elastic-agent install --fleet-server-es=http://elasticsearch:9200 \
  --fleet-server-service-token=AbEAAdesYXN1abMvZmxlZXQtc2VldmVyL3Rva2VuLTE2MTkxMzg3MzIzMTg7dzEta0JDTmZUcGlDTjlwRmNVTjNVQQ \
  --fleet-server-policy=a35fd620-26f6-11ec-8bd9-3374690f57b6
```

Start Elastic Agent with Fleet Server (running on a custom CA). This example assumes you’ve generated the certificates with the following names:
- `ca.crt`: Root CA certificate
- `fleet-server.crt`: Fleet Server certificate
- `fleet-server.key`: Fleet Server private key
- `elasticsearch-ca.crt`: CA certificate to use to connect to Elasticsearch

```shell
elastic-agent install \
  --url=https://fleet-server:8220 \
  --fleet-server-es=https://elasticsearch:9200 \
  --fleet-server-service-token=AAEBAWVsYXm0aWMvZmxlZXQtc2XydmVyL3Rva2VuLTE2MjM4OTAztDU1OTQ6dllfVW1mYnFTVjJwTC2ZQ0EtVnVZQQ \
  --fleet-server-policy=a35fd520-26f5-11ec-8bd9-3374690g57b6 \
  --certificate-authorities=/path/to/ca.crt \
  --fleet-server-es-ca=/path/to/elasticsearch-ca.crt \
  --fleet-server-cert=/path/to/fleet-server.crt \
  --fleet-server-cert-key=/path/to/fleet-server.key \
  --fleet-server-port=8220
```

Then install another Elastic Agent and enroll it into the Fleet Server started in the previous example:
```shell
elastic-agent install --url=https://fleet-server:8220 \
  --enrollment-token=NEFmVllaa0JLRXhKebVKVTR5TTI6N2JaVlJpSGpScmV0ZUVnZVlRUExFQQ== \
  --certificate-authorities=/path/to/ca.crt
```


## elastic-agent otel

Run Elastic Agent as an [Elastic Distribution of OpenTelemetry Collector (EDOT Collector)](https://www.elastic.co/docs/reference/fleet/otel-agent).

### Synopsis

```shell
elastic-agent otel [flags]
elastic-agent otel [command]
```

<note>
  You can also run the `./otelcol` command, which calls `./elastic-agent otel` and passes any arguments to it.
</note>


### Available commands

<definitions>
  <definition term="validate">
    Validates the OpenTelemetry collector configuration without running the collector.
  </definition>
</definitions>


### Flags

<definitions>
  <definition term="--config=file:/path/to/first --config=file:path/to/second">
    Locations to the config file(s). Only a single location can be set per flag entry, for example `--config=file:/path/to/first --config=file:path/to/second`.
  </definition>
  <definition term="--feature-gates flag">
    Comma-delimited list of feature gate identifiers. Prefix with `-` to disable the feature. Prefixing with `+` or no prefix will enable the feature.
  </definition>
  <definition term="-h, --help">
    Get help for the `otel` sub-command. Use `elastic-agent otel [command] --help` for more information about a command.
  </definition>
  <definition term="--set string">
    Set an arbitrary component config property. The component has to be defined in the configuration file and the flag has a higher precedence. Array configuration properties are overridden and maps are joined. For example, `--set=processors::batch::timeout=2s`.
  </definition>
</definitions>


### Examples

Run Elastic Agent as an EDOT Collector using the supplied `otel.yml` configuration file.
```shell
./elastic-agent otel --config otel.yml
```

Change the default verbosity setting in the Elastic Agent EDOT Collector configuration from `detailed` to `normal`.
```shell
./elastic-agent otel --config otel.yml --set "exporters::debug::verbosity=normal"
```


## elastic-agent restart

Restart the currently running Elastic Agent daemon.

### Synopsis

```shell
elastic-agent restart [--help] [global-flags]
```


### Options

<definitions>
  <definition term="--help">
    Show help for the `restart` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

```shell
elastic-agent restart
```


## elastic-agent run

Start the `elastic-agent` process.

### Synopsis

```shell
elastic-agent run [global-flags]
```


### Global flags

These flags are valid whenever you run `elastic-agent` on the command line.
<definitions>
  <definition term="-c <string>">
    The configuration file to use. If not specified, Elastic Agent uses `{path.config}/elastic-agent.yml`.
  </definition>
  <definition term="--e">
    Log to stderr and disable syslog/file output.
  </definition>
  <definition term="--environment <environmentVar>">
    The environment in which the agent will run.
  </definition>
  <definition term="--path.config <string>">
    The directory where Elastic Agent looks for its configuration file. The default varies by platform.
  </definition>
  <definition term="--path.home <string>">
    The root directory of Elastic Agent. `path.home` determines the location of the configuration files and data directory.
    If not specified, Elastic Agent uses the current working directory.
  </definition>
  <definition term="--path.logs <string>">
    Path to the log output for Elastic Agent. The default varies by platform.
  </definition>
  <definition term="--v">
    Set log level to INFO.
  </definition>
</definitions>


### Example

```shell
elastic-agent run -c myagentconfig.yml
```


## elastic-agent status

Returns the current status of the running Elastic Agent daemon and of each process in the Elastic Agent.  The last known status of the Fleet server is also returned. The `output` option controls the level of detail and formatting of the information.

### Synopsis

```shell
elastic-agent status [--output <string>]
                     [--help]
                     [global-flags]
```


### Options

<definitions>
  <definition term="--output <string>">
    Output the status information in either `human` (the default), `full`, `json`, or `yaml`.  `human` returns limited information when Elastic Agent is in the `HEALTHY` state. If any components or units are not in `HEALTHY` state, then full details are displayed for that component or unit.  `full`, `json` and `yaml` always return the full status information.  Components map to individual processes running underneath Elastic Agent, for example Filebeat or Endpoint Security. Units map to discrete configuration units within that process, for example Filebeat inputs or Metricbeat modules.
  </definition>
</definitions>

When the output is `json` or `yaml`, status codes are returned as numerical values.  The status codes can be mapped using the following table:
+

| Code | Status        |
|------|---------------|
| 0    | `STARTING`    |
| 1    | `CONFIGURING` |
| 2    | `HEALTHY`     |
| 3    | `DEGRADED`    |
| 4    | `FAILED`      |
| 5    | `STOPPING`    |
| 6    | `UPGRADING`   |
| 7    | `ROLLBACK`    |

<definitions>
  <definition term="--help">
    Show help for the `status` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

```shell
elastic-agent status
```


## elastic-agent uninstall

Permanently uninstall Elastic Agent from the system.
You must run this command as the root user (or Administrator on Windows) to remove files.
<important>
  Be sure to run the `uninstall` command from a directory outside of where Elastic Agent is installed.For example, on a Windows system the install location is `C:\Program Files\Elastic\Agent`. Run the uninstall command from `C:\Program Files\Elastic` or `\tmp`, or even your default home directory:
  ```shell
  C:\"Program Files"\Elastic\Agent\elastic-agent.exe uninstall
  ```
</important>

<tab-set>
  <tab-item title="macOS">
    <tip>
      You must run this command as the root user.
    </tip>

    ```shell
    sudo /Library/Elastic/Agent/elastic-agent uninstall
    ```
  </tab-item>

  <tab-item title="Linux">
    <tip>
      You must run this command as the root user.
    </tip>

    ```shell
    sudo /opt/Elastic/Agent/elastic-agent uninstall
    ```
  </tab-item>

  <tab-item title="Windows">
    Open a PowerShell prompt as an Administrator (right-click the PowerShell icon and select **Run As Administrator**).From the PowerShell prompt, run:
    ```shell
    C:\"Program Files"\Elastic\Agent\elastic-agent.exe uninstall
    ```
  </tab-item>
</tab-set>


### Synopsis

```shell
elastic-agent uninstall [--force] [--help] [global-flags]
```


### Options

<definitions>
  <definition term="--force">
    Uninstall Elastic Agent and do not prompt for confirmation. This flag is helpful when using automation software or scripted deployments.
  </definition>
  <definition term="--skip-fleet-audit">
    Skip auditing with the Fleet Server.
  </definition>
  <definition term="--help">
    Show help for the `uninstall` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

```shell
elastic-agent uninstall
```


## elastic-agent unprivileged

Run Elastic Agent without full superuser privileges. This is useful in organizations that limit `root` access on Linux or macOS systems, or `admin` access on Windows systems. For details and limitations for running Elastic Agent in this mode, refer to [Run Elastic Agent without administrative privileges](https://www.elastic.co/docs/reference/fleet/elastic-agent-unprivileged).
Changing a running Elastic Agent to `unprivileged` mode is prevented if the agent is currently enrolled with a policy that contains the Elastic Defend integration.
<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> To run Elastic Agent without superuser privileges as a pre-existing user or group, for instance under an Active Directory account, add either a `--user` or `--group` parameter together with a `--password` parameter.

### Examples

Run Elastic Agent without administrative privileges:
```shell
elastic-agent unprivileged
```

<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> Run Elastic Agent without administrative privileges, as a pre-existing user:
```shell
elastic-agent unprivileged --user="my.pathl\username" --password="mypassword"
```

<applies-to>Elastic Stack: Preview</applies-to> <applies-to>Elastic Cloud Serverless: Preview</applies-to> Run Elastic Agent without administrative privileges, as a pre-existing group:
```shell
elastic-agent unprivileged --group="my.pathl\groupname" --password="mypassword"
```


## elastic-agent upgrade

Upgrade the currently running Elastic Agent to the specified version. This should only be used with agents running in standalone mode. Agents enrolled in Fleet should be upgraded through Fleet.

### Synopsis

```shell
elastic-agent upgrade <version> [--source-uri <string>] [--help] [flags]
```


### Options

<definitions>
  <definition term="version">
    The version of Elastic Agent to upgrade to.
  </definition>
  <definition term="--source-uri <string>">
    The source URI to download the new version from. By default, Elastic Agent uses the Elastic Artifacts URL.
  </definition>
  <definition term="--skip-verify">
    Skip the package verification process. This option is not recommended as it is insecure.
  </definition>
  <definition term="--pgp-path <string>">
    Use a locally stored copy of the PGP key to verify the upgrade package.
  </definition>
  <definition term="--pgp-uri <string>">
    Use the specified online PGP key to verify the upgrade package.
  </definition>
  <definition term="--help">
    Show help for the `upgrade` command.
  </definition>
</definitions>

For details about using the `--skip-verify`, `--pgp-path <string>`, and `--pgp-uri <string>` package verification options, refer to [Verifying Elastic Agent package signatures](/docs/reference/fleet/upgrade-standalone#upgrade-standalone-verify-package).
For more flags, see [Global flags](#elastic-agent-global-flags).

### Examples

```shell
elastic-agent upgrade 7.10.1
```


## elastic-agent logs

Show the logs of the running Elastic Agent.

### Synopsis

```shell
elastic-agent logs [--follow] [--number <int>] [--component <string>] [--no-color] [--help] [global-flags]
```


### Options

<definitions>
  <definition term="--follow or -f">
    Follow log updates until the command is interrupted (for example with `Ctrl-C`).
  </definition>
  <definition term="--number <int> or -n <int>">
    How many lines of logs to print. If logs following is enabled, affects the initial output.
  </definition>
  <definition term="--component <string> or -C <string>">
    Filter logs based on the component name.
  </definition>
  <definition term="--no-color">
    Disable color based on log-level of each entry.
  </definition>
  <definition term="--help">
    Show help for the `logs` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Example

```shell
elastic-agent logs -n 100 -f -C "system/metrics-default"
```


## elastic-agent version

Show the version of Elastic Agent.

### Synopsis

```shell
elastic-agent version [--help] [global-flags]
```


### Options

<definitions>
  <definition term="--help">
    Show help for the `version` command.
  </definition>
</definitions>

For more flags, see [Global flags](#elastic-agent-global-flags).

### Example

```shell
elastic-agent version
```