﻿---
title: Advanced Elastic Agent configuration managed by Fleet
description: For basic Elastic Agent managed by Fleet scenarios follow the steps in Run Elastic Agent on Kubernetes managed by Fleet. On managed Elastic Agent installations...
url: https://www.elastic.co/docs/reference/fleet/advanced-kubernetes-managed-by-fleet
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Advanced Elastic Agent configuration managed by Fleet
For basic Elastic Agent managed by Fleet scenarios follow the steps in [Run Elastic Agent on Kubernetes managed by Fleet](https://www.elastic.co/docs/reference/fleet/running-on-kubernetes-managed-by-fleet).
On managed Elastic Agent installations it can be useful to provide the ability to configure more advanced options, such as the configuration of providers during the startup. Refer to [Providers](https://www.elastic.co/docs/reference/fleet/providers) for more details.
Following steps demonstrate above scenario:

## Step 1: Download the Elastic Agent manifest

It is advisable to follow the steps of [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent) with Kubernetes Integration installed in your policy and download the Elastic Agent manifest from Kibana UI
![Elastic Agent with K8s Package manifest](https://www.elastic.co/docs/reference/fleet/images/k8skibanaUI.png)

<definitions>
  <definition term="Notes">
    Sample manifests can also be found [here](https://github.com/elastic/elastic-agent/blob/main/deploy/kubernetes/elastic-agent-managed-kubernetes.yaml)
  </definition>
</definitions>


## Step 2: Create a new configmap

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  name: agent-node-datastreams
  namespace: kube-system
  labels:
    k8s-app: elastic-agent
data:
  agent.yml: |-
    providers.kubernetes_leaderelection.enabled: false
    fleet.enabled: true
    fleet.access_token: "<FLEET_ENROLLMENT_TOKEN>"
---
```

<definitions>
  <definition term="Notes">
    1. In the above example the disablement of `kubernetes_leaderelection` provider is demonstrated. Same procedure can be followed for alternative scenarios.
  </definition>
</definitions>

```yaml
apiVersion: v1
kind: ConfigMap
metadata:
  name: agent-node-datastreams
  namespace: kube-system
  labels:
    k8s-app: elastic-agent
data:
  agent.yml: |-
    providers.kubernetes:
      add_resource_metadata:
        deployment: true
        cronjob: true
    fleet.enabled: true
    fleet.access_token: "<FLEET_ENROLLMENT_TOKEN>"
---
```

1. Find more information about [Enrollment Tokens](https://www.elastic.co/docs/reference/fleet/fleet-enrollment-tokens).


## Step 3: Configure Daemonset

Inside the downloaded manifest, update the Daemonset resource:
```yaml
containers:
  - name: elastic-agent
    image: docker.elastic.co/elastic-agent/elastic-agent: <ImageVersion>
    args: ["-c", "/etc/elastic-agent/agent.yml", "-e"]
```

<definitions>
  <definition term="Notes">
    The <ImageVersion> is a placeholder for the elastic-agent image version that you will download in your manifest: eg. `image: docker.elastic.co/elastic-agent/elastic-agent: 8.11.0` Important thing is to update your manifest with args details
  </definition>
</definitions>

```yaml
volumeMounts:
  - name: datastreams
    mountPath: /etc/elastic-agent/agent.yml
    readOnly: true
    subPath: agent.yml
```

```yaml
volumes:
  - name: datastreams
    configMap:
      defaultMode: 0640
      name: agent-node-datastreams
```


## Important Notes

1. By default the manifests for Elastic Agent managed by Fleet have `hostNetwork:true`. In order to support multiple installations of Elastic Agents in the same node you should set `hostNetwork:false`. See this relevant [example](https://github.com/elastic/elastic-agent/tree/main/docs/manifests/hostnetwork) as described in [Elastic Agent Manifests in order to support Kube-State-Metrics Sharding](https://github.com/elastic/elastic-agent/blob/main/docs/elastic-agent-ksm-sharding.md).
2. The volume `/usr/share/elastic-agent/state` must remain mounted in [elastic-agent-managed-kubernetes.yaml](https://github.com/elastic/elastic-agent/blob/main/deploy/kubernetes/elastic-agent-managed-kubernetes.yaml), otherwise custom config map provided above will be overwritten.
3. If Elastic Agent is deployed through ECK, you can define the provider configuration in the `spec.config` field of the Kubernetes custom resource. Refer to [Fleet-managed Elastic Agent on ECK](https://www.elastic.co/docs/deploy-manage/deploy/cloud-on-k8s/configuration-fleet) for details.