﻿---
title: Add tags
description: The add_tags processor adds tags to a list of tags. If the target field already exists, the tags are appended to the existing list of tags. This configuration:...
url: https://www.elastic.co/docs/reference/fleet/add_tags-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add tags
The `add_tags` processor adds tags to a list of tags. If the target field already exists, the tags are appended to the existing list of tags.

## Example

This configuration:
```yaml
  - add_tags:
      tags: [web, production]
      target: "environment"
```

Adds the `environment` field to every event:
```json
{
  "environment": ["web", "production"]
}
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default | Description                                                                    |
|----------|----------|---------|--------------------------------------------------------------------------------|
| `tags`   | Yes      |         | List of tags to add.                                                           |
| `target` | No       | `tags`  | Field the tags will be added to. Setting tags in `@metadata` is not supported. |