﻿---
title: Add network direction
description: The add_network_direction processor attempts to compute the perimeter-based network direction when given a source and destination IP address and a list...
url: https://www.elastic.co/docs/reference/fleet/add_network_direction-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add network direction
The `add_network_direction` processor attempts to compute the perimeter-based network direction when given a source and destination IP address and a list of internal networks.

## Example

```yaml
  - add_network_direction:
      source: source.ip
      destination: destination.ip
      target: network.direction
      internal_networks: [ private ]
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name                | Required | Default | Description                                                                                                                                                                                                      |
|---------------------|----------|---------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `source`            | Yes      |         | Source IP.                                                                                                                                                                                                       |
| `destination`       | Yes      |         | Destination IP.                                                                                                                                                                                                  |
| `target`            | Yes      |         | Target field where the network direction will be written.                                                                                                                                                        |
| `internal_networks` | Yes      |         | List of internal networks. The value can contain either CIDR blocks or a list of special values enumerated in the network section of [Conditions](/docs/reference/fleet/dynamic-input-configuration#conditions). |