﻿---
title: Add the local time zone
description: The add_locale processor enriches each event with either the machine’s time zone offset from UTC or the name of the time zone. The processor adds the...
url: https://www.elastic.co/docs/reference/fleet/add_locale-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add the local time zone
The `add_locale` processor enriches each event with either the machine’s time zone offset from UTC or the name of the time zone. The processor adds the a `event.timezone` value to each event.

## Examples

The configuration adds the processor with the default settings:
```yaml
  - add_locale: ~
```

This configuration adds the processor and configures it to add the time zone abbreviation to events:
```yaml
  - add_locale:
      format: abbreviation
```

<note>
  The `add_locale` processor differentiates between daylight savings time (DST) and regular time. For example `CEST` indicates DST and and `CET` is regular time.
</note>


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default  | Description                                                            |
|----------|----------|----------|------------------------------------------------------------------------|
| `format` | No       | `offset` | Whether an `offset` or time zone `abbreviation` is added to the event. |