﻿---
title: Add labels
description: The add_labels processors adds a set of key-value pairs to an event. The processor flattens nested configuration objects like arrays or dictionaries into...
url: https://www.elastic.co/docs/reference/fleet/add_labels-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add labels
The `add_labels` processors adds a set of key-value pairs to an event. The processor flattens nested configuration objects like arrays or dictionaries into a fully qualified name by merging nested names with a dot (`.`). Array entries create numeric names starting with 0. Labels are always stored under the Elastic Common Schema compliant `labels` sub-dictionary.

## Example

This configuration:
```yaml
  - add_labels:
      labels:
        number: 1
        with.dots: test
        nested:
          with.dots: nested
        array:
          - do
          - re
          - with.field: mi
```

Adds these fields to every event:
```json
{
  "labels": {
    "number": 1,
    "with.dots": "test",
    "nested.with.dots": "nested",
    "array.0": "do",
    "array.1": "re",
    "array.2.with.field": "mi"
  }
}
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name     | Required | Default | Description                         |
|----------|----------|---------|-------------------------------------|
| `labels` | Yes      |         | Dictionaries of labels to be added. |