﻿---
title: Generate an ID for an event
description: The add_id processor generates a unique ID for an event. 
url: https://www.elastic.co/docs/reference/fleet/add_id-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Generate an ID for an event
The `add_id` processor generates a unique ID for an event.

## Example

```yaml
  - add_id: ~
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>


| Name           | Required | Default         | Description                                                                                                                                                                  |
|----------------|----------|-----------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `target_field` | No       | `@metadata._id` | Field where the generated ID will be stored.                                                                                                                                 |
| `type`         | No       | `elasticsearch` | Type of ID to generate. Currently only `elasticsearch` is supported. The `elasticsearch` type uses the same algorithm that Elasticsearch uses to auto-generate document IDs. |