﻿---
title: Add Host metadata
description: The add_host_metadata processor annotates each event with relevant metadata from the host machine. The fields added to the event look like this: 
url: https://www.elastic.co/docs/reference/fleet/add_host_metadata-processor
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add Host metadata
<tip>
  Inputs that collect logs and metrics use this processor by default, so you do not need to configure it explicitly.
</tip>

The `add_host_metadata` processor annotates each event with relevant metadata from the host machine.
<note>
  If you are using Elastic Agent to monitor external system, use the [`add_observer_metadata`](https://www.elastic.co/docs/reference/fleet/add_observer_metadata-processor) processor instead of `add_host_metadata`.
</note>


## Example

```yaml
  - add_host_metadata:
      cache.ttl: 5m
      geo:
        name: nyc-dc1-rack1
        location: 40.7128, -74.0060
        continent_name: North America
        country_iso_code: US
        region_name: New York
        region_iso_code: NY
        city_name: New York
```

The fields added to the event look like this:
```json
{
   "host":{
      "architecture":"x86_64",
      "name":"example-host",
      "id":"",
      "os":{
         "family":"darwin",
         "type":"macos",
         "build":"16G1212",
         "platform":"darwin",
         "version":"10.12.6",
         "kernel":"16.7.0",
         "name":"Mac OS X"
      },
      "ip": ["192.168.0.1", "10.0.0.1"],
      "mac": ["00:25:96:12:34:56", "72:00:06:ff:79:f1"],
      "geo": {
          "continent_name": "North America",
          "country_iso_code": "US",
          "region_name": "New York",
          "region_iso_code": "NY",
          "city_name": "New York",
          "name": "nyc-dc1-rack1",
          "location": "40.7128, -74.0060"
        }
   }
}
```


## Configuration settings

<note>
  Elastic Agent processors execute *before* ingest pipelines, which means that they process the raw event data rather than the final event sent to Elasticsearch. For related limitations, refer to [What are some limitations of using processors?](/docs/reference/fleet/agent-processors#limitations)
</note>

<important>
  If `host.*` fields already exist in the event, they are overwritten by default unless you set `replace_fields` to `true` in the processor configuration.
</important>


| Name                   | Required | Default | Description                                                                                                                                                                                                                                                                                                                                                                          |
|------------------------|----------|---------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `netinfo.enabled`      | No       | `true`  | Whether to include IP addresses and MAC addresses as fields `host.ip` and `host.mac`.                                                                                                                                                                                                                                                                                                |
| `cache.ttl`            | No       | `5m`    | Sets the cache expiration time for the internal cache used by the processor. Negative values disable caching altogether.                                                                                                                                                                                                                                                             |
| `geo.name`             | No       |         | User-definable token to be used for identifying a discrete location. Frequently a data center, rack, or similar.                                                                                                                                                                                                                                                                     |
| `geo.location`         | No       |         | Longitude and latitude in comma-separated format.                                                                                                                                                                                                                                                                                                                                    |
| `geo.continent_name`   | No       |         | Name of the continent.                                                                                                                                                                                                                                                                                                                                                               |
| `geo.country_name`     | No       |         | Name of the country.                                                                                                                                                                                                                                                                                                                                                                 |
| `geo.region_name`      | No       |         | Name of the region.                                                                                                                                                                                                                                                                                                                                                                  |
| `geo.city_name`        | No       |         | Name of the city.                                                                                                                                                                                                                                                                                                                                                                    |
| `geo.country_iso_code` | No       |         | ISO country code.                                                                                                                                                                                                                                                                                                                                                                    |
| `geo.region_iso_code`  | No       |         | ISO region code.                                                                                                                                                                                                                                                                                                                                                                     |
| `replace_fields`       | No       | `true`  | Whether to replace existing host fields in the event. If `true` (default), the processor always runs and overwrites any existing `host.*` fields with metadata from `add_host_metadata`. If `false`, the processor only adds metadata when no `host.*` fields exist in the event or when only `host.name` is present. If other host fields exist, the processor is skipped entirely. |