﻿---
title: Add an integration to an Elastic Agent policy
description: An Elastic Agent policy consists of one or more integrations that are applied to the agents enrolled in that policy. When you add an integration, the...
url: https://www.elastic.co/docs/reference/fleet/add-integration-to-policy
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Add an integration to an Elastic Agent policy
An [Elastic Agent policy](https://www.elastic.co/docs/reference/fleet/agent-policy) consists of one or more integrations that are applied to the agents enrolled in that policy. When you add an integration, the policy created for that integration can be shared with multiple Elastic Agent policies. This reduces the number of integrations policies that you need to actively manage.
To add a new integration to one or more Elastic Agent policies:
1. In Kibana, go to the **Integrations** page.
2. The Integrations page shows Elastic Agent integrations along with other types, such as Beats. Scroll down and select **Elastic Agent only** to view only integrations that work with Elastic Agent.
3. Search for and select an integration. You can select a category to narrow your search.
4. Click **Add <integration>**.
5. You can opt to install an Elastic Agent if you haven’t already, or choose **Add integration only** to proceed.
6. In Step 1 on the **Add <integration>** page, you can select the configuration settings specific to the integration.
7. In Step 2 on the page, you have two options:
   1. If you’d like to create a new policy for your Elastic Agents, on the **New hosts** tab specify a name for the new agent policy and choose whether or not to collect system logs and metrics. Collecting logs and metrics will add the System integration to the new agent policy.
2. If you already have an Elastic Agent policy created, on the **Existing hosts** tab use the drop-down menu to specify one or more agent policies that you’d like to add the integration to.
8. Click **Save and continue** to confirm your settings.

This action installs the integration (if it’s not already installed) and adds it to the Elastic Agent policies that you specified. Fleet distributes the new integration policy to all Elastic Agents that are enrolled in the agent policies.
You can update the settings for an installed integration at any time:
1. In Kibana, go to the **Integrations** page.
2. On the **Integration policies** tab, for the integration that you like to update open the **Actions** menu and select **Edit integration**.
3. On the **Edit <integration>** page you can update any configuration settings and also update the list of Elastic Agent polices to which the integration is added.
   If you clear the **Agent policies** field, the integration will be removed from any Elastic Agent policies to which it had been added.
   To identify any integrations that have been "orphaned", that is, not associated with any Elastic Agent policies, check the **Agent polices** column on the **Integration policies** tab. Any integrations that are installed but not associated with an Elastic Agent policy are as labeled as `No agent policies`.

If you haven’t deployed any Elastic Agents yet or set up agent policies, start with one of our quick start guides:
- [Get started with logs and metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics)
- [Get started with application traces and APM](https://www.elastic.co/docs/solutions/observability/apm/get-started)