﻿---
title: Deploy on-premises and self-managed Fleet Server
description: To use Fleet for central management, a Fleet Server must be running and accessible to your hosts. You can deploy Fleet Server on-premises and manage it...
url: https://www.elastic.co/docs/reference/fleet/add-fleet-server-on-prem
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Enterprise: Generally available
  - Self-managed Elastic deployments: Generally available
---

# Deploy on-premises and self-managed Fleet Server
To use Fleet for central management, a [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) must be running and accessible to your hosts.
You can deploy Fleet Server on-premises and manage it yourself. In this [deployment model](https://www.elastic.co/docs/reference/fleet/deployment-models), you are responsible for high-availability, fault-tolerance, and lifecycle management of Fleet Server.
This approach might be right for you if you would like to limit the control plane traffic out of your data center or have requirements for fully air-gapped operations. For example, you might take this approach if you need to satisfy data governance requirements or you want agents to only have access to a private segmented network.
This approach might *not* be right for you if you don’t want to manage the life cycle of your Elastic environment and instead would like that to be handled by Elastic.
When using this approach, it’s recommended that you provision multiple instances of the Fleet Server and use a load balancer to better scale the deployment. You also have the option to use your organization’s certificate to establish a secure connection from Fleet Server to Elasticsearch.
![Fleet Server on-premises deployment model](https://www.elastic.co/docs/reference/fleet/images/fleet-server-on-prem-deployment.png)

To deploy a self-managed Fleet Server, you need to:
- Satisfy all [compatibility requirements](#add-fleet-server-on-prem-compatibility) and [prerequisites](#add-fleet-server-on-prem-prereq).
- [Add a Fleet Server](#add-fleet-server-on-prem-add-server) by installing an Elastic Agent and enrolling it in an agent policy containing the Fleet Server integration.

<note>
  You can install only a single Elastic Agent per host, which means you cannot run Fleet Server and another Elastic Agent on the same host unless you deploy a containerized Fleet Server.
</note>


## Compatibility

Fleet Server is compatible with the following Elastic products:
- Elastic Stack 7.13 or later.
  - For version compatibility, Elasticsearch must be at the same or a later version than Fleet Server, and Fleet Server needs to be at the same or a later version than Elastic Agent (not including patch releases).
- Kibana should be on the same minor version as Elasticsearch.
- Elastic Cloud Enterprise 2.9 or later
  - Requires additional wildcard domains and certificates (which normally only cover `*.cname`, not `*.*.cname`). This enables us to provide the URL for Fleet Server of `https://.fleet.`.
- The deployment template must contain an Integrations Server node.
  For more information about hosting Fleet Server on Elastic Cloud Enterprise, refer to [Manage Integrations Server in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-integrations-server).


## Prerequisites

Before deploying, you need to:
- Obtain or generate a Certificate Authority (CA) certificate.
- Ensure components have access to the ports needed for communication.


### CA certificate

Before setting up Fleet Server using this approach, you will need a CA certificate to configure Transport Layer Security (TLS) to encrypt traffic between the Fleet Servers and the Elastic Stack.
If your organization already uses the Elastic Stack, you may already have a CA certificate. If you do not have a CA certificate, you can read more about generating one in [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections).
<note>
  This is not required when testing and iterating using the **Quick start** option, but should always be used for production deployments.
</note>


### Default port assignments

When Elasticsearch or Fleet Server are deployed, components communicate over well-defined, pre-allocated ports. You may need to allow access to these ports. Refer to the following table for default port assignments:

| Component communication        | Default port |
|--------------------------------|--------------|
| Elastic Agent → Fleet Server   | 8220         |
| Elastic Agent → Elasticsearch  | 9200         |
| Elastic Agent → Logstash       | 5044         |
| Elastic Agent → Kibana (Fleet) | 5601         |
| Fleet Server → Kibana (Fleet)  | 5601         |
| Fleet Server → Elasticsearch   | 9200         |

<note>
  Connectivity to Kibana on port 5601 is optional and not required at all times. Elastic Agent and Fleet Server may need to connect to Kibana if deployed in a container environment where an enrollment token can not be provided during deployment.
</note>


## Add Fleet Server

A Fleet Server is an Elastic Agent that is enrolled in a Fleet Server policy. The policy configures the agent to operate in a special mode to serve as a Fleet Server in your deployment.
To add a Fleet Server:
1. In Fleet, open the **Agents** tab.
2. Click **Add Fleet Server**.
3. This opens in-product instructions to add a Fleet Server using one of two options: **Quick Start** or **Advanced**.
   - Use **Quick Start** if you want Fleet to generate a Fleet Server policy and enrollment token for you. The Fleet Server policy will include a Fleet Server integration plus a system integration for monitoring Elastic Agent. This option generates self-signed certificates and is **not** recommended for production use cases.
  ![In-product instructions for adding a Fleet Server in quick start mode](https://www.elastic.co/docs/reference/fleet/images/add-fleet-server.png)
- Use **Advanced** if you want to either:
  - **Use your own Fleet Server policy.** Fleet Server policies manage and configure the Elastic Agent running on Fleet Server hosts to launch a Fleet Server process. You can create a new Fleet Server policy or select an existing one. Alternatively you can [create a Fleet Server policy without using the UI](https://www.elastic.co/docs/reference/fleet/create-policy-no-ui), and then select the policy here.
- **Use your own TLS certificates.** TLS certificates encrypt traffic between Elastic Agents and Fleet Server. To learn how to generate certs, refer to [Configure SSL/TLS for self-managed Fleet Servers](https://www.elastic.co/docs/reference/fleet/secure-connections).
  <note>
  If you are providing your own certificates:
  - Before running the `install` command, make sure you replace the values in angle brackets.
  - The URL specified by `--url` must match the DNS name used to generate the certificate specified by `--fleet-server-cert`.
  </note>
  ![In-product instructions for adding a Fleet Server in advanced mode](https://www.elastic.co/docs/reference/fleet/images/add-fleet-server-advanced.png)
4. Step through the in-product instructions to configure and install Fleet Server.
   <note>
   - The fields to configure Fleet Server hosts are not available if the hosts are already configured outside of Fleet. For more information, refer to [Fleet settings in Kibana](https://www.elastic.co/docs/reference/kibana/configuration-reference/fleet-settings).
   - When using the **Advanced** option, it’s recommended to generate a unique service token for each Fleet Server. For other ways to generate service tokens, refer to [`elasticsearch-service-tokens`](https://www.elastic.co/docs/reference/elasticsearch/command-line-tools/service-tokens-command).
   - If you’ve configured a non-default port for Fleet Server in the Fleet Server integration, you need to include the `--fleet-server-host` and `--fleet-server-port` options in the `elastic-agent install` command. Refer to the [install command documentation](/docs/reference/fleet/agent-command-reference#elastic-agent-install-command) for details.
   </note>
   At the **Install Fleet Server to a centralized host** step, the `elastic-agent install` command installs an Elastic Agent as a managed service and enrolls it in a Fleet Server policy. For more Fleet Server commands, refer to the [Elastic Agent command reference](https://www.elastic.co/docs/reference/fleet/agent-command-reference).
5. If installation is successful, a confirmation indicates that Fleet Server is set up and connected.

After Fleet Server is installed and enrolled in Fleet, the newly created Fleet Server policy is applied. You can see this on the Fleet Server policy page.
The Fleet Server agent also shows up on the main Fleet page as another agent whose life-cycle can be managed (like other agents in the deployment).
You can update your Fleet Server configuration in Kibana at any time by going to: **Management** → **Fleet** → **Settings**. From there you can:
- Update the Fleet Server host URL.
- Configure additional outputs where agents should send data.
- Specify the location from where agents should download binaries.
- Specify proxy URLs to use for Fleet Server or Elastic Agent outputs.


## Troubleshooting

If you’re unable to add a Fleet-managed agent, click the **Agents** tab and confirm that the agent running Fleet Server is healthy.

## Next steps

Now you’re ready to add Elastic Agents to your host systems. To learn how, see [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).
<note>
  For on-premises deployments, you can dedicate a policy to all the agents in the network boundary and configure that policy to include a specific Fleet Server (or a cluster of Fleet Servers).Read more in [Add a Fleet Server to a policy](/docs/reference/fleet/agent-policy#add-fleet-server-to-policy).
</note>