﻿---
title: Deploy Fleet Server on Elastic Cloud
description: To use Fleet for central management, a Fleet Server must be running and accessible to your hosts. Fleet Server can be provisioned and hosted on Elastic...
url: https://www.elastic.co/docs/reference/fleet/add-fleet-server-cloud
products:
  - Elastic Agent
  - Fleet
applies_to:
  - Elastic Cloud Serverless: Unavailable
  - Elastic Cloud Hosted: Generally available
  - Elastic Cloud Enterprise: Generally available
---

# Deploy Fleet Server on Elastic Cloud
To use Fleet for central management, a [Fleet Server](https://www.elastic.co/docs/reference/fleet/fleet-server) must be running and accessible to your hosts.
Fleet Server can be provisioned and hosted on Elastic Cloud. When the Cloud deployment is created, a highly available set of Fleet Servers is provisioned automatically.
This approach might be right for you if you want to reduce on-prem compute resources and you’d like Elastic to take care of provisioning and life cycle management of your deployment.
With this approach, multiple Fleet Servers are automatically provisioned to satisfy the chosen instance size (instance sizes are modified to satisfy the scale requirement). You can also choose the resources allocated to each Fleet Server and whether you want each Fleet Server to be deployed in multiple availability zones. If you choose multiple availability zones to address your fault-tolerance requirements, those instances are also utilized to balance the load.
This approach might *not* be right for you if you have restrictions on connectivity to the internet.
![Fleet Server Cloud deployment model](https://www.elastic.co/docs/reference/fleet/images/fleet-server-cloud-deployment.png)


## Compatibility and prerequisites

Fleet Server is compatible with the following Elastic products:
- Elastic Stack 7.13 or later.
  - For version compatibility, Elasticsearch must be at the same or a later version than Fleet Server, and Fleet Server needs to be at the same or a later version than Elastic Agent (not including patch releases).
- Kibana should be on the same minor version as Elasticsearch.
- Elastic Cloud Enterprise 2.10 or later
  - Requires additional wildcard domains and certificates (which normally only cover `*.cname`, not `*.*.cname`). This enables us to provide the URL for Fleet Server of `https://.fleet.`.
- The deployment template must contain an Integrations Server node.
  For more information about hosting Fleet Server on Elastic Cloud Enterprise, refer to [Manage Integrations Server in Elastic Cloud Enterprise](https://www.elastic.co/docs/deploy-manage/deploy/cloud-enterprise/manage-integrations-server).

<note>
  The TLS certificates used to secure connections between Elastic Agent and Fleet Server are managed by Elastic Cloud. You do not need to create a private key or generate certificates.
</note>

When Elasticsearch or Fleet Server are deployed, components communicate over well-defined, pre-allocated ports. You may need to allow access to these ports. See the following table for default port assignments:

| Component communication        | Default port |
|--------------------------------|--------------|
| Elastic Agent → Fleet Server   | 443          |
| Elastic Agent → Elasticsearch  | 443          |
| Elastic Agent → Logstash       | 5044         |
| Elastic Agent → Kibana (Fleet) | 443          |
| Fleet Server → Kibana (Fleet)  | 443          |
| Fleet Server → Elasticsearch   | 443          |

<note>
  If you do not specify the port for Elasticsearch as 443, the Elastic Agent defaults to 9200.
</note>


## Setup

To confirm that an Integrations Server is available in your deployment:
1. Open Fleet.
2. On the **Agent policies** tab, look for the **Elastic Cloud agent policy**. This policy is managed by Elastic Cloud, and contains a Fleet Server integration and an Elastic APM integration. You cannot modify the policy. Confirm that the agent status is **Healthy**.

<tip>
  Don’t see the agent? Make sure your deployment includes an Integrations Server instance. This instance is required to use Fleet.
  ![Hosted Integrations Server](https://www.elastic.co/docs/reference/fleet/images/integrations-server-hosted-container.png)
</tip>


## Next steps

Now you’re ready to add Elastic Agents to your host systems. To learn how, see [Install Fleet-managed Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-fleet-managed-elastic-agent).