﻿---
title: Fleet and Elastic Agent overview
description: Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security...
url: https://www.elastic.co/docs/reference/fleet
products:
  - Elastic Cloud Serverless
  - Fleet
  - Kibana
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Fleet and Elastic Agent overview
## Elastic Agent

Elastic Agent is a single, unified way to add monitoring for logs, metrics, and other types of data to a host. It can also protect hosts from security threats, query data from operating systems, forward data from remote services or hardware, and more. A single agent makes it easier and faster to deploy monitoring across your infrastructure. Each agent has a single policy you can update to add integrations for new data sources, security protections, and more.
As the following diagram illustrates, Elastic Agent can monitor the host where it's deployed, and it can collect and forward data from remote services and hardware where direct deployment is not possible.
![Image showing Elastic Agent collecting data from local host and remote services](https://www.elastic.co/docs/reference/fleet/images/agent-architecture.png)

To learn about installation options, refer to [Install Elastic Agents](https://www.elastic.co/docs/reference/fleet/install-elastic-agents).
<note>
  Using Fleet and Elastic Agent with Elastic Cloud Serverless? Note these [restrictions](https://www.elastic.co/docs/reference/fleet/fleet-agent-serverless-restrictions).
</note>

<tip>
  Looking for a general guide that explores all of your options for ingesting data? Check out [Adding data to Elasticsearch](https://www.elastic.co/docs/manage-data/ingest).
</tip>


## Integrations

[Integrations](https://www.elastic.co/docs/reference/integrations) provide an easy way to connect Elastic to external services and systems, and quickly get insights or take action. They can collect new sources of data, and they often ship with out-of-the-box assets like dashboards, visualizations, and pipelines to extract structured fields out of logs and events. This makes it easier to get insights within seconds. Integrations are available for popular services and platforms like Nginx or AWS, as well as many generic input types like log files.
Kibana provides a web-based UI to add and manage integrations. You can browse a unified view of available integrations that shows both Elastic Agent and Beats integrations.
![Integrations page](https://www.elastic.co/docs/reference/fleet/images/integrations.png)


## Elastic Agent policies

Agent policies specify which integrations you want to run and on which hosts. You can apply an Elastic Agent policy to multiple agents, making it even easier to manage configuration at scale.
![Add integration page](https://www.elastic.co/docs/reference/fleet/images/add-integration.png)

When you add an integration, you configure inputs for logs and metrics, such as the path to your Nginx access logs. When you're done, you save the integration to an Elastic Agent policy. The next time enrolled agents check in, they receive the update. Having the policies automatically deployed is more convenient than doing it yourself by using SSH, Ansible playbooks, or some other tool.
For more information, refer to [Elastic Agent policies](https://www.elastic.co/docs/reference/fleet/agent-policy).
If you prefer infrastructure as code, you may use YAML files and APIs. Fleet has an API-first design. Anything you can do in the UI, you can also do using the API. This makes it easy to automate and integrate with other systems.

## Elastic Package Registry

The Elastic Package Registry is an online package hosting service for the Elastic Agent integrations available in Kibana.
Kibana connects to the Elastic Package Registry at `epr.elastic.co` using the Elastic Package Manager, downloads the latest integration package, and stores its assets in Elasticsearch. This process typically requires an internet connection because integrations are updated and released periodically. You can find more information about running the Elastic Package Registry in air-gapped environments in the section about [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped).

## Elastic Artifact Registry

Fleet and Elastic Agent require access to the public Elastic Artifact Registry. The Elastic Agent running on any of your internal hosts should have access to `artifacts.elastic.co` in order to perform self-upgrades and install of certain components which are needed for some of the data integrations.
Additionally, access to `artifacts.security.elastic.co` is needed for Elastic Agent updates and security artifacts when using Elastic Defend.
You can find more information about running the above mentioned resources in air-gapped environments in the section about [Air-gapped environments](https://www.elastic.co/docs/reference/fleet/air-gapped).

## Central management in Fleet

Fleet provides a web-based UI in Kibana for centrally managing Elastic Agents and their policies.
You can see the state of all your Elastic Agents in Fleet. On the **Agents** page, you can see which agents are healthy or unhealthy, and the last time they checked in. You can also see the version of the Elastic Agent binary and policy.
![Agents page](https://www.elastic.co/docs/reference/fleet/images/kibana-fleet-agents.png)

Fleet in Kibana enables you to manage Elastic Agent installations in standalone or Fleet mode.
Standalone mode requires you to manually configure and manage the agent locally. It is recommended for advanced users only.
Fleet mode offers several advantages:
- A central place to configure and monitor your Elastic Agents.
- Ability to trigger Elastic Agent binary and policy upgrades remotely.
- An overview of the data ingest in your Elasticsearch cluster.

![Fleet app in Kibana](https://www.elastic.co/docs/reference/fleet/images/fleet-start.png)

Fleet serves as the communication channel back to the Elastic Agents. Agents check in for the latest updates on a regular basis. You can have any number of agents enrolled into each agent policy, which allows you to scale up to thousands of hosts.
When you make a change to an agent policy, all the agents receive the update during their next check-in. You no longer have to distribute policy updates yourself.
When you're ready to upgrade your Elastic Agent binaries or integrations, you can initiate upgrades in Fleet, and the Elastic Agents running on your hosts will upgrade automatically.

### Roll out changes to many Elastic Agents quickly

Some subscription levels support bulk select operations, including:
- Selective agent binary updates
- Selective agent policy reassignment
- Selective agent unenrollment

This capability enables you to apply changes and trigger updates across many Elastic Agents so you can roll out changes quickly across your organization.
For more information, refer to [Elastic Stack subscriptions](https://www.elastic.co/subscriptions).

## Fleet Server

Fleet Server is the mechanism to connect Elastic Agents to Fleet. It allows for a scalable infrastructure and is supported in Elastic Cloud and self-managed clusters. Fleet Server is a separate process that communicates with the deployed Elastic Agents. It can be started from any available x64 architecture Elastic Agent artifact.
For more information, refer to [What is Fleet Server?](https://www.elastic.co/docs/reference/fleet/fleet-server).
<admonition title="Fleet Server with Elastic Cloud Serverless" applies-to="Elastic Cloud Serverless: Unavailable">
  On-premises Fleet Server is not currently available for use in an [Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/serverless) environment. We recommend using the hosted Fleet Server that is included and configured automatically in Serverless Observability and Security projects.
</admonition>


## Elasticsearch as the communication layer

All communication between the Fleet UI and Fleet Server happens through Elasticsearch. Fleet writes policies, actions, and any changes to the `fleet-*` indices in Elasticsearch. Each Fleet Server monitors the indices, picks up changes, and ships them to the Elastic Agents. To communicate to Fleet about the status of the Elastic Agents and the policy rollout, the Fleet Servers write updates to the `fleet-*` indices.

## Elastic Agent self-protection

On macOS and Windows, when the Elastic Defend integration is added to the agent policy, Elastic Endpoint can prevent malware from executing on the host. For more information, refer to [Elastic Endpoint self-protection](https://www.elastic.co/docs/solutions/security/manage-elastic-defend/elastic-endpoint-self-protection-features).

## Data streams make index management easier

The data collected by Elastic Agent is stored in indices that are more granular than you'd get by default with the Beats shippers or APM Server. This gives you more visibility into the sources of data volume, and control over lifecycle management policies and index permissions. These indices are called [data streams](https://www.elastic.co/docs/reference/fleet/data-streams).

## Quick starts

Want to get up and running with Fleet and Elastic Agent quickly? Read our getting started guides:
- [Get started with logs and metrics](https://www.elastic.co/docs/solutions/observability/infra-and-hosts/get-started-with-system-metrics)
- [Get started with APM](https://www.elastic.co/docs/solutions/observability/apm/get-started)