﻿---
title: Split processor
description: Splits a field into an array using a separator character. Only works on string fields. If the preserve_trailing option is enabled, any trailing empty...
url: https://www.elastic.co/docs/reference/enrich-processor/split-processor
products:
  - Elasticsearch
---

# Split processor
Splits a field into an array using a separator character. Only works on string fields.


| Name                | Required | Default | Description                                                                                                                                                                             |
|---------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `field`             | yes      | -       | The field to split                                                                                                                                                                      |
| `separator`         | yes      | -       | A regex which matches the separator, eg `,` or `\s+`                                                                                                                                    |
| `target_field`      | no       | `field` | The field to assign the split value to, by default `field` is updated in-place                                                                                                          |
| `ignore_missing`    | no       | `false` | If `true` and `field` does not exist, the processor quietly exits without modifying the document                                                                                        |
| `preserve_trailing` | no       | `false` | Preserves empty trailing fields, if any.                                                                                                                                                |
| `description`       | no       | -       | Description of the processor. Useful for describing the purpose of the processor or its configuration.                                                                                  |
| `if`                | no       | -       | Conditionally execute the processor. See [Conditionally run a processor](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#conditionally-run-processor). |
| `ignore_failure`    | no       | `false` | Ignore failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).       |
| `on_failure`        | no       | -       | Handle failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).       |
| `tag`               | no       | -       | Identifier for the processor. Useful for debugging and metrics.                                                                                                                         |

```js
{
  "split": {
    "field": "my_field",
    "separator": "\\s+" 
  }
}
```

If the `preserve_trailing` option is enabled, any trailing empty fields in the input will be preserved. For example, in the configuration below, a value of `A,,B,,` in the `my_field` property will be split into an array of five elements `["A", "", "B", "", ""]` with two empty trailing fields. If the `preserve_trailing` property were not enabled, the two empty trailing fields would be discarded resulting in the three-element array `["A", "", "B"]`.
```js
{
  "split": {
    "field": "my_field",
    "separator": ",",
    "preserve_trailing": true
  }
}
```