﻿---
title: Remove processor
description: Removes existing fields. If one field doesn’t exist, an exception will be thrown. Here is an example to remove a single field: To remove multiple fields,...
url: https://www.elastic.co/docs/reference/enrich-processor/remove-processor
products:
  - Elasticsearch
---

# Remove processor
Removes existing fields. If one field doesn’t exist, an exception will be thrown.


| Name             | Required | Default | Description                                                                                                                                                                                                       |
|------------------|----------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `field`          | yes      | -       | Fields to be removed. Supports [template snippets](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#template-snippets). This parameter is not required if you use `keep` instead. |
| `ignore_missing` | no       | `false` | If `true` and `field` does not exist or is `null`, the processor quietly exits without modifying the document                                                                                                     |
| `keep`           | no       | -       | Fields to keep. When set, all fields other than those specified are removed.                                                                                                                                      |
| `description`    | no       | -       | Description of the processor. Useful for describing the purpose of the processor or its configuration.                                                                                                            |
| `if`             | no       | -       | Conditionally execute the processor. See [Conditionally run a processor](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#conditionally-run-processor).                           |
| `ignore_failure` | no       | `false` | Ignore failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).                                 |
| `on_failure`     | no       | -       | Handle failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).                                 |
| `tag`            | no       | -       | Identifier for the processor. Useful for debugging and metrics.                                                                                                                                                   |

Here is an example to remove a single field:
```js
{
  "remove": {
    "field": "user_agent"
  }
}
```

To remove multiple fields, you can use the following query:
```js
{
  "remove": {
    "field": ["user_agent", "url"]
  }
}
```

You can also choose to remove all fields other than a specified list:
```js
{
  "remove": {
    "keep": ["url"]
  }
}
```