﻿---
title: Drop processor
description: Drops the document without raising any errors. This is useful to prevent the document from getting indexed based on some condition. 
url: https://www.elastic.co/docs/reference/enrich-processor/drop-processor
products:
  - Elasticsearch
---

# Drop processor
Drops the document without raising any errors. This is useful to prevent the document from getting indexed based on some condition.


| Name             | Required | Default | Description                                                                                                                                                                             |
|------------------|----------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `description`    | no       | -       | Description of the processor. Useful for describing the purpose of the processor or its configuration.                                                                                  |
| `if`             | no       | -       | Conditionally execute the processor. See [Conditionally run a processor](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#conditionally-run-processor). |
| `ignore_failure` | no       | `false` | Ignore failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).       |
| `on_failure`     | no       | -       | Handle failures for the processor. See [Handling pipeline failures](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines#handling-pipeline-failures).       |
| `tag`            | no       | -       | Identifier for the processor. Useful for debugging and metrics.                                                                                                                         |

```js
{
  "drop": {
    "if" : "ctx.network_name == 'Guest'"
  }
}
```