﻿---
title: Ingest processor reference
description: An ingest pipeline is made up of a sequence of processors that are applied to documents as they are ingested into an index. Each processor performs a...
url: https://www.elastic.co/docs/reference/enrich-processor
products:
  - Elasticsearch
---

# Ingest processor reference
<note>
  This section provides detailed **reference information** for ingest processors.Refer to [Transform and enrich data](https://www.elastic.co/docs/manage-data/ingest/transform-enrich) in the **Manage data** section for overview and conceptual information.
</note>

An [ingest pipeline](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/ingest-pipelines) is made up of a sequence of processors that are applied to documents as they are ingested into an index. Each processor performs a specific task, such as filtering, transforming, or enriching data.
Each successive processor depends on the output of the previous processor, so the order of processors is important. The modified documents are indexed into Elasticsearch after all processors are applied.
Elasticsearch includes over 40 configurable processors. The subpages in this section contain reference documentation for each processor. To get a list of available processors, use the [nodes info](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-nodes-info) API.
```json
```


## Ingest processors by category

We’ve categorized the available processors on this page and summarized their functions. This will help you find the right processor for your use case.
- [Data enrichment processors](#ingest-process-category-data-enrichment)
- [Data transformation processors](#ingest-process-category-data-transformation)
- [Data filtering processors](#ingest-process-category-data-filtering)
- [Pipeline handling processors](#ingest-process-category-pipeline-handling)
- [Array/JSON handling processors](#ingest-process-category-array-json-handling)


## Data enrichment processors


### General outcomes

<definitions>
  <definition term="append processor">
    Appends a value to a field.
  </definition>
  <definition term="date_index_name processor">
    Points documents to the right time-based index based on a date or timestamp field.
  </definition>
  <definition term="enrich processor">
    Enriches documents with data from another index.
  </definition>
</definitions>

<tip>
  Refer to [Enrich your data](https://www.elastic.co/docs/manage-data/ingest/transform-enrich/data-enrichment) for detailed examples of how to use the `enrich` processor to add data from your existing indices to incoming documents during ingest.
</tip>

<definitions>
  <definition term="inference processor">
    Uses machine learning to classify and tag text fields.
  </definition>
</definitions>


### Specific outcomes

<definitions>
  <definition term="attachment processor">
    Parses and indexes binary data, such as PDFs and Word documents.
  </definition>
  <definition term="circle processor">
    Converts a location field to a Geo-Point field.
  </definition>
  <definition term="community_id processor">
    Computes the Community ID for network flow data.
  </definition>
  <definition term="fingerprint processor">
    Computes a hash of the document’s content.
  </definition>
  <definition term="geo_grid processor">
    Converts geo-grid definitions of grid tiles or cells to regular bounding boxes or polygons which describe their shape.
  </definition>
  <definition term="geoip processor">
    Adds information about the geographical location of an IPv4 or IPv6 address from a Maxmind database.
  </definition>
  <definition term="ip_location processor">
    Adds information about the geographical location of an IPv4 or IPv6 address from an ip geolocation database.
  </definition>
  <definition term="network_direction processor">
    Calculates the network direction given a source IP address, destination IP address, and a list of internal networks.
  </definition>
  <definition term="normalize_for_stream processor Elastic Stack: Preview since 9.1">
    Normalizes non-OpenTelemetry documents to be OpenTelemetry-compliant.
  </definition>
  <definition term="registered_domain processor">
    Extracts the registered domain (also known as the effective top-level domain or eTLD), sub-domain, and top-level domain from a fully qualified domain name (FQDN).
  </definition>
  <definition term="set_security_user processor">
    Sets user-related details (such as `username`,  `roles`, `email`, `full_name`,`metadata`, `api_key`, `realm` and `authentication_type`) from the current authenticated user.
  </definition>
  <definition term="uri_parts processor">
    Parses a Uniform Resource Identifier (URI) string and extracts its components as an object.
  </definition>
  <definition term="urldecode processor">
    URL-decodes a string.
  </definition>
  <definition term="user_agent processor">
    Parses user-agent strings to extract information about web clients.
  </definition>
</definitions>


## Data transformation processors


### General outcomes

<definitions>
  <definition term="convert processor">
    Converts a field in the currently ingested document to a different type, such as converting a string to an integer.
  </definition>
  <definition term="dissect processor">
    Extracts structured fields out of a single text field within a document. Unlike the [grok processor](https://www.elastic.co/docs/reference/enrich-processor/grok-processor), dissect does not use regular expressions. This makes the dissect’s a simpler and often faster alternative.
  </definition>
  <definition term="grok processor">
    Extracts structured fields out of a single text field within a document, using the [Grok](https://www.elastic.co/docs/explore-analyze/scripting/grok) regular expression dialect that supports reusable aliased expressions.
  </definition>
  <definition term="gsub processor">
    Converts a string field by applying a regular expression and a replacement.
  </definition>
  <definition term="redact processor">
    Uses the [Grok](https://www.elastic.co/docs/explore-analyze/scripting/grok) rules engine to obscure text in the input document matching the given Grok patterns.
  </definition>
  <definition term="rename processor">
    Renames an existing field.
  </definition>
  <definition term="set processor">
    Sets a value on a field.
  </definition>
</definitions>


### Specific outcomes

<definitions>
  <definition term="bytes processor">
    Converts a human-readable byte value to its value in bytes (for example `1kb` becomes `1024`).
  </definition>
  <definition term="cef processor">
    Extracts fields from a Common Event Format (CEF) messages.
  </definition>
  <definition term="csv processor">
    Extracts a single line of CSV data from a text field.
  </definition>
  <definition term="date processor">
    Extracts and converts date fields.
  </definition>
  <definition term="dot_expand processor">
    Expands a field with dots into an object field.
  </definition>
  <definition term="html_strip processor">
    Removes HTML tags from a field.
  </definition>
  <definition term="join processor">
    Joins each element of an array into a single string using a separator character between each element.
  </definition>
  <definition term="kv processor">
    Parse messages (or specific event fields) containing key-value pairs.
  </definition>
  <definition term="lowercase processor and uppercase processor">
    Converts a string field to lowercase or uppercase.
  </definition>
  <definition term="recover_failure_document processor">
    Converts a failure-store document to its original format.
  </definition>
  <definition term="split processor">
    Splits a field into an array of values.
  </definition>
  <definition term="trim processor">
    Trims whitespace from field.
  </definition>
</definitions>


## Data filtering processors

<definitions>
  <definition term="drop processor">
    Drops the document without raising any errors.
  </definition>
  <definition term="remove processor">
    Removes fields from documents.
  </definition>
</definitions>


## Pipeline handling processors

<definitions>
  <definition term="fail processor">
    Raises an exception. Useful for when you expect a pipeline to fail and want to relay a specific message to the requester.
  </definition>
  <definition term="pipeline processor">
    Executes another pipeline.
  </definition>
  <definition term="reroute processor">
    Reroutes documents to another target index or data stream.
  </definition>
  <definition term="terminate processor">
    Terminates the current ingest pipeline, causing no further processors to be run.
  </definition>
</definitions>


## Array/JSON handling processors

<definitions>
  <definition term="for_each processor">
    Runs an ingest processor on each element of an array or object.
  </definition>
  <definition term="json processor">
    Parses a string containing JSON data into a structured object, string, or other value.
  </definition>
  <definition term="script processor">
    Runs an inline or stored [script](https://www.elastic.co/docs/explore-analyze/scripting) on incoming documents. The script runs in the [painless `ingest` context](https://www.elastic.co/docs/reference/scripting-languages/painless/painless-ingest-processor-context).
  </definition>
  <definition term="sort processor">
    Sorts the elements of an array in ascending or descending order.
  </definition>
</definitions>


## Add additional processors

You can install additional processors as [plugins](https://www.elastic.co/docs/reference/elasticsearch/plugins).
You must install any plugin processors on all nodes in your cluster. Otherwise, Elasticsearch will fail to create pipelines containing the processor.
Mark a plugin as mandatory by setting `plugin.mandatory` in `elasticsearch.yml`. A node will fail to start if a mandatory plugin is not installed.
```yaml
plugin.mandatory: my-ingest-plugin
```