﻿---
title: Elasticsearch privileges
description: This section provides detailed reference information for Elasticsearch privileges. If you're using a stack-versioned deployment such as a self-managed...
url: https://www.elastic.co/docs/reference/elasticsearch/security-privileges
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Elasticsearch privileges
This section provides detailed **reference information** for Elasticsearch privileges.
If you're using a stack-versioned deployment such as a self-managed cluster, Elastic Cloud Hosted, Elastic Cloud on Kubernetes, or Elastic Cloud Enterprise, then refer to [User roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles) for more information on how role-based access control works.
If you're using Elastic Cloud Serverless, then refer to [Serverless project custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/serverless-custom-roles) to learn how to build roles using these privileges.
<note>
  In Elastic Cloud Serverless, Elastic manages the underlying infrastructure for you. Because of this, privileges related to cluster administration, scaling, snapshots, and availability are not available. [Learn more about the features managed by Elastic Cloud Serverless](https://www.elastic.co/docs/deploy-manage/deploy/elastic-cloud/differences-from-other-elasticsearch-offerings).
</note>

Roles are governed by a set of configurable privileges grouped into these categories:
- [cluster](#privileges-list-cluster), which you can use to manage core operations like snapshots, managing API keys, autoscaling, and cross-cluster functionality.
- [indices](#privileges-list-indices), which govern document-level access, index and data stream metadata information, and more.
- [run-as](#_run_as_privilege), which allows for secure impersonation.
- [application](#application-privileges), which enable external applications to define and store their privilege models within Elasticsearch roles.

When creating roles, refer to this page for a complete list of available privileges.

## Cluster privileges

<definitions>
  <definition term="all">
    All cluster administration operations, like snapshotting, node shutdown/restart, settings update, rerouting, or managing users and roles.
  </definition>
  <definition term="cancel_task">
    Privileges to cancel tasks and delete async searches. See [delete async search](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-async-search-submit) API for more informations.
  </definition>
  <definition term="create_snapshot Elastic Cloud Serverless: Unavailable">
    Privileges to create snapshots for existing repositories. Can also list and view details on existing repositories and snapshots.
  </definition>
  <definition term="cross_cluster_replication Elastic Cloud Serverless: Unavailable">
    Privileges to connect to [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key) for cross-cluster replication.
    <note>
      This privilege must *not* be directly granted. It is used internally by [Create Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) and [Update Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-update-cross-cluster-api-key) to manage cross-cluster API keys.
    </note>
  </definition>
  <definition term="cross_cluster_search Elastic Cloud Serverless: Unavailable">
    Privileges to connect to [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key) for cross-cluster search.
    <note>
      This privilege must *not* be directly granted. It is used internally by [Create Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) and [Update Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-update-cross-cluster-api-key) to manage cross-cluster API keys.
    </note>
  </definition>
  <definition term="grant_api_key Elastic Cloud Serverless: Unavailable">
    Privileges to create Elasticsearch API keys on behalf of other users.
  </definition>
  <definition term="manage">
    Builds on `monitor` and adds cluster operations that change values in the cluster. This includes snapshotting, updating settings, and rerouting. It also includes obtaining snapshot and restore status. This privilege does not include the ability to manage security.
  </definition>
  <definition term="manage_api_key">
    All security-related operations on Elasticsearch REST API keys including [creating new API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), [retrieving information about API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-api-key), [querying API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-query-api-keys), [updating API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-update-api-key), [bulk updating API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-bulk-update-api-keys), and [invalidating API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-api-key).
    <note>
      - When you create new API keys, they will always be owned by the authenticated user.
      - When you have this privilege, you can invalidate your own API keys and those owned by other users.
    </note>
  </definition>
  <definition term="manage_autoscaling Elastic Cloud Serverless: Unavailable">
    All operations related to managing autoscaling policies.
  </definition>
  <definition term="manage_ccr Elastic Cloud Serverless: Unavailable">
    All cross-cluster replication operations related to managing follower indices and auto-follow patterns. It also includes the authority to grant the privileges necessary to manage follower indices and auto-follow patterns. This privilege is necessary only on clusters that contain follower indices.
  </definition>
  <definition term="manage_data_frame_transforms Elastic Cloud Serverless: Unavailable Elastic Stack: Deprecated since 7.5">
    Use `manage_transform` instead. Elasticsearch version 7.5 and older used `manage_data_frame_transforms` in operations related to managing transforms.
  </definition>
  <definition term="manage_data_stream_global_retention Elastic Stack: Deprecated since 8.16">
    This privilege has no effect.
  </definition>
  <definition term="manage_enrich">
    All operations related to managing and executing enrich policies.
  </definition>
  <definition term="manage_ilm Elastic Cloud Serverless: Unavailable">
    All index lifecycle management operations related to managing policies.
  </definition>
  <definition term="manage_index_templates">
    All operations on index templates.
  </definition>
  <definition term="manage_inference">
    All operations related to managing inference.
  </definition>
  <definition term="manage_ingest_pipelines">
    All operations on ingest pipelines.
  </definition>
  <definition term="manage_logstash_pipelines">
    All operations on logstash pipelines.
  </definition>
  <definition term="manage_ml">
    All machine learning operations, such as creating and deleting datafeeds, jobs, and model snapshots.
    <note>
      Datafeeds that were created prior to version 6.2 or created when security features were disabled run as a system user with elevated privileges, including permission to read all indices. Newer datafeeds run with the security roles of the user who created or updated them.
    </note>
  </definition>
  <definition term="manage_oidc Elastic Cloud Serverless: Unavailable">
    Enables the use of Elasticsearch APIs ([OpenID connect prepare authentication](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-oidc-prepare-authentication), [OpenID connect authenticate](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-oidc-authenticate), and [OpenID connect logout](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-oidc-logout)) to initiate and manage OpenID Connect authentication on behalf of other users.
  </definition>
  <definition term="manage_own_api_key">
    All security-related operations on Elasticsearch API keys that are owned by the current authenticated user. The operations include [creating new API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-api-key), [retrieving information about API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-api-key), [querying API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-query-api-keys), [updating API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-update-api-key), [bulk updating API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-bulk-update-api-keys), and [invalidating API keys](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-invalidate-api-key).
  </definition>
  <definition term="manage_pipeline">
    All operations on ingest pipelines.
  </definition>
  <definition term="manage_rollup Elastic Cloud Serverless: Unavailable">
    All rollup operations, including creating, starting, stopping and deleting rollup jobs.
  </definition>
  <definition term="manage_saml Elastic Cloud Serverless: Unavailable">
    Enables the use of internal Elasticsearch APIs to initiate and manage SAML authentication on behalf of other users.
  </definition>
  <definition term="manage_search_application">
    All CRUD operations on [search applications](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-search_application).
  </definition>
  <definition term="manage_search_query_rules">
    All CRUD operations on [query rules](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-query_rules).
  </definition>
  <definition term="manage_search_synonyms">
    All synonyms management operations on [Synonyms APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-synonyms).
  </definition>
  <definition term="manage_security">
    All security-related operations such as CRUD operations on users and roles and cache clearing.
  </definition>
  <definition term="manage_service_account Elastic Cloud Serverless: Unavailable">
    All security-related operations on Elasticsearch service accounts including [Get service accounts](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-service-accounts), [Create service account tokens](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-service-token), [Delete service account token](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-delete-service-token), and [Get service account credentials](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-service-credentials).
  </definition>
  <definition term="manage_slm Elastic Cloud Serverless: Unavailable Elastic Stack: Deprecated since 8.15">
    All snapshot lifecycle management (SLM) actions, including creating and updating policies and starting and stopping SLM. It also grants the permission to start and stop index lifecycle management, using the [ILM start](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-start) and [ILM stop](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-stop) APIs.
    In a future major release, this privilege will not grant any index lifecycle management permissions.
  </definition>
  <definition term="manage_token Elastic Cloud Serverless: Unavailable">
    All security-related operations on tokens that are generated by the Elasticsearch Token Service.
  </definition>
  <definition term="manage_transform">
    All operations related to managing transforms.
  </definition>
  <definition term="manage_watcher Elastic Cloud Serverless: Unavailable">
    All watcher operations, such as putting watches, executing, activate or acknowledging.
    <note>
      Watches that were created prior to version 6.1 or created when the security features were disabled run as a system user with elevated privileges, including permission to read and write all indices. Newer watches run with the security roles of the user who created or updated them.
    </note>
  </definition>
  <definition term="monitor">
    All cluster read-only operations, like cluster health and state, hot threads, node info, node and cluster stats, and pending cluster tasks.
  </definition>
  <definition term="monitor_data_stream_global_retention Elastic Stack: Deprecated since 8.16, Elastic Stack: Unavailable">
    This privilege has no effect.
  </definition>
  <definition term="monitor_enrich">
    All read-only operations related to managing and executing enrich policies.
  </definition>
  <definition term="monitor_esql Elastic Stack: Generally available since 9.1">
    All read-only operations related to ESQL queries.
  </definition>
  <definition term="monitor_inference">
    All read-only operations related to inference.
  </definition>
  <definition term="monitor_ml">
    All read-only machine learning operations, such as getting information about datafeeds, jobs, model snapshots, or results.
  </definition>
  <definition term="monitor_rollup Elastic Cloud Serverless: Unavailable">
    All read-only rollup operations, such as viewing the list of historical and currently running rollup jobs and their capabilities.
  </definition>
  <definition term="monitor_snapshot Elastic Cloud Serverless: Unavailable">
    Privileges to list and view details on existing repositories and snapshots.
  </definition>
  <definition term="monitor_stats Elastic Cloud Serverless: Unavailable">
    Privileges to list and view details of stats.
  </definition>
  <definition term="monitor_text_structure Elastic Cloud Serverless: Unavailable">
    All read-only operations related to the [find structure API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-text-structure-find-structure).
  </definition>
  <definition term="monitor_transform">
    All read-only operations related to transforms.
  </definition>
  <definition term="monitor_watcher Elastic Cloud Serverless: Unavailable">
    All read-only watcher operations, such as getting a watch and watcher stats.
  </definition>
  <definition term="read_ccr Elastic Cloud Serverless: Unavailable">
    All read-only cross-cluster replication operations, such as getting information about indices and metadata for leader indices in the cluster. It also includes the authority to check whether users have the appropriate privileges to follow leader indices. This privilege is necessary only on clusters that contain leader indices.
  </definition>
  <definition term="read_ilm Elastic Cloud Serverless: Unavailable">
    All read-only index lifecycle management operations, such as getting policies and checking the status of {Ilm}
  </definition>
  <definition term="read_pipeline">
    Read-only access to ingest pipeline (get, simulate).
  </definition>
  <definition term="read_slm Elastic Cloud Serverless: Unavailable Elastic Stack: Deprecated since 8.15">
    All read-only SLM actions, such as getting policies and checking the SLM status. It also grants the permission to get the index lifecycle management status, using the [ILM get status API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ilm-get-status).
    In a future major release, this privilege will not grant any index lifecycle management permissions.
  </definition>
  <definition term="read_security">
    All read-only security-related operations, such as getting users, user profiles, Elasticsearch API keys, Elasticsearch service accounts, roles and role mappings. Allows [querying](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-query-api-keys) and [retrieving information](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-api-key) on all Elasticsearch API keys.
  </definition>
  <definition term="transport_client Elastic Cloud Serverless: Unavailable">
    All privileges necessary for a transport client to connect. Required by the remote cluster to enable [cross-cluster search](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed).
  </definition>
</definitions>


## Indices privileges

<definitions>
  <definition term="all">
    Any action on an index or data stream.
  </definition>
  <definition term="auto_configure">
    Permits auto-creation of indices and data streams. An auto-create action is the result of an [index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) or [bulk](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-bulk) request that targets a non-existent index or data stream rather than an explicit [create index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create) or [create data stream](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-create-data-stream) request. Also permits auto-update of mappings on indices and data streams if they do not contradict existing mappings. An auto-update mapping action is the result of an index or bulk request on an index or data stream that contains new fields that may be mapped rather than an explicit [update mapping](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) request.
  </definition>
  <definition term="create">
    Privilege to index documents.
    <note>
      This privilege does not restrict the index operation to the creation of documents but instead restricts API use to the index API. The index API allows a user to overwrite a previously indexed document. See the `create_doc` privilege for an alternative.
    </note>
    <important>
      Starting from 8.0, this privilege no longer grants the permission to update index mappings.
      In earlier versions, it implicitly permitted index mapping updates (excluding data stream mappings) via the [updating mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) or through [dynamic field mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping).
      Mapping update capabilities will be fully removed in a future major release.
    </important>
  </definition>
  <definition term="create_doc">
    Privilege to index documents. It does not grant the permission to update or overwrite existing documents.
    <note>
      This privilege relies on the `op_type` of indexing requests ([Index](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-create) and [Bulk](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-bulk)). When ingesting documents as a user who has the `create_doc` privilege (and no higher privilege such as `index` or `write`), you must ensure that *op_type* is set to *create* through one of the following:
    </note>
    - Explicitly setting the `op_type` in the index or bulk APIs
    - Using the `_create` endpoint for the index API
    - Creating a document with an auto-generated `_id`
    <important>
      Starting from 8.0, this privilege no longer grants the permission to update index mappings.
      In earlier versions, it implicitly permitted index mapping updates (excluding data stream mappings) via the [updating mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) or through [dynamic field mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping).
      Mapping update capabilities will be fully removed in a future major release.
    </important>
  </definition>
  <definition term="create_index Elastic Cloud Serverless: Unavailable">
    Privilege to create an index or data stream. A create index request may contain aliases to be added to the index once created. In that case the request requires the `manage` privilege as well, on both the index and the aliases names.
  </definition>
  <definition term="cross_cluster_replication Elastic Cloud Serverless: Unavailable">
    Privileges to perform cross-cluster replication for indices located on [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key). This privilege should only be used for the `privileges` field of [remote indices privileges](https://www.elastic.co/guide/en/elasticsearch/reference/current/defining-roles.html#roles-remote-indices-priv).
  </definition>
  <definition term="cross_cluster_replication_internal Elastic Cloud Serverless: Unavailable">
    Privileges to perform supporting actions for cross-cluster replication from [remote clusters configured with the API key based model](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-api-key).
    <note>
      This privilege must *not* be directly granted. It is used internally by [Create Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-create-cross-cluster-api-key) and [Update Cross-Cluster API key](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-update-cross-cluster-api-key) to manage cross-cluster API keys.
    </note>
  </definition>
  <definition term="delete">
    Privilege to delete documents.
  </definition>
  <definition term="delete_index">
    Privilege to delete an index or data stream.
  </definition>
  <definition term="index">
    Privilege to index and update documents.
    <important>
      Starting from 8.0, this privilege no longer grants the permission to update index mappings.
      In earlier versions, it implicitly permitted index mapping updates (excluding data stream mappings) via the [updating mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) or through [dynamic field mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping).
      Mapping update capabilities will be fully removed in a future major release.
    </important>
  </definition>
  <definition term="maintenance">
    Permits refresh, flush, synced flush and force merge index administration operations. No privilege to read or write index data or otherwise manage the index.
  </definition>
  <definition term="manage">
    All `monitor` privileges plus index and data stream administration (aliases, analyze, cache clear, close, delete, exists, flush, mapping, open, field capabilities, force merge, refresh, settings, search shards, validate query).
  </definition>
  <definition term="manage_data_stream_lifecycle">
    All [Data stream lifecycle](https://www.elastic.co/docs/manage-data/lifecycle/data-stream) operations relating to reading and managing the built-in lifecycle of a data stream. This includes operations such as adding and removing a lifecycle from a data stream.
  </definition>
  <definition term="manage_failure_store Elastic Stack: Generally available since 9.1">
    All `monitor` privileges plus index and data stream administration limited to failure stores only. Applies only to data streams when accessed through the [index component selector syntax](/docs/reference/elasticsearch/rest-apis/api-conventions#api-component-selectors).
  </definition>
  <definition term="manage_follow_index Elastic Cloud Serverless: Unavailable">
    All actions that are required to manage the lifecycle of a follower index, which includes creating a follower index, closing it, and converting it to a regular index. This privilege is necessary only on clusters that contain follower indices.
  </definition>
  <definition term="manage_ilm Elastic Cloud Serverless: Unavailable">
    All index lifecycle management operations relating to managing the execution of policies of an index or data stream. This includes operations such as retrying policies and removing a policy from an index or data stream.
  </definition>
  <definition term="manage_leader_index Elastic Cloud Serverless: Unavailable">
    All actions that are required to manage the lifecycle of a leader index, which includes [forgetting a follower](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-ccr-forget-follower). This privilege is necessary only on clusters that contain leader indices.
  </definition>
  <definition term="monitor">
    All actions that are required for monitoring (recovery, segments info, index stats and status).
  </definition>
  <definition term="read">
    Read-only access to actions (count, explain, get, mget, get indexed scripts, more like this, multi percolate/search/termvector, percolate, scroll, clear_scroll, search, suggest, tv).
  </definition>
  <definition term="read_cross_cluster Elastic Cloud Serverless: Unavailable">
    Read-only access to the search action from a [remote cluster](https://www.elastic.co/docs/deploy-manage/remote-clusters/remote-clusters-self-managed).
  </definition>
  <definition term="read_failure_store Elastic Stack: Generally available since 9.1">
    Read-only access to actions performed on a data stream's failure store. Required for access to failure store data (count, explain, get, mget, get indexed scripts, more like this, multi percolate/search/termvector, percolate, scroll, clear_scroll, search, suggest, tv). Applies only to data streams when accessed through the [index component selector syntax](/docs/reference/elasticsearch/rest-apis/api-conventions#api-component-selectors).
  </definition>
  <definition term="view_index_metadata">
    Read-only access to index and data stream metadata (aliases, exists, field capabilities, field mappings, get index, get data stream, ilm explain, mappings, search shards, settings, validate query). This privilege is available for use primarily by Kibana users.
  </definition>
  <definition term="write">
    Privilege to perform all write operations to documents, which includes the permission to index, update, and delete documents as well as performing bulk operations, while also allowing to dynamically update the index mapping.
    <important>
      Starting from 8.0, this privilege no longer grants the permission to update index mappings.
      In earlier versions, it implicitly permitted index mapping updates (excluding data stream mappings) via the [updating mapping API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-indices-put-mapping) or through [dynamic field mapping](https://www.elastic.co/docs/manage-data/data-store/mapping/dynamic-mapping).
      Mapping update capabilities will be fully removed in a future major release.
    </important>
  </definition>
</definitions>


## Run as privilege

<applies-to>
  - Elastic Cloud Serverless: Unavailable
</applies-to>

The `run_as` permission enables an authenticated user to submit requests on behalf of another user. The value can be a user name or a comma-separated list of user names. (You can also specify users as an array of strings or a YAML sequence.) For more information, see [Submitting requests on behalf of other users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users).

## Application privileges

Application privileges are managed within Elasticsearch and can be retrieved with the [has privileges API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-has-privileges) and the [get application privileges API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-get-privileges). They do not, however, grant access to any actions or resources within Elasticsearch. Their purpose is to enable applications to represent and store their own privilege models within Elasticsearch roles.
To create application privileges, use the [add application privileges API](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-security-put-privileges). You can then associate these application privileges with roles, as described in [Defining roles](https://www.elastic.co/guide/en/elasticsearch/reference/current/defining-roles.html).