﻿---
title: Built-in roles
description: This section provides detailed reference information for Elasticsearch roles. To learn how to apply roles for Elastic Stack, and to learn how role-based...
url: https://www.elastic.co/docs/reference/elasticsearch/roles
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Built-in roles
This section provides detailed **reference information** for Elasticsearch roles.
To learn how to apply roles for Elastic Stack, and to learn how role-based access control works, refer to [User roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/user-roles).
<tip>
  Elastic Cloud Serverless uses a different set of predefined roles. To learn more about the roles available in Serverless projects, refer to [Elastic Cloud Serverless predefined roles](https://www.elastic.co/docs/deploy-manage/users-roles/cloud-organization/user-roles#general-assign-user-roles-table).
</tip>

The Elastic Stack security features apply a default role to all users, including [anonymous users](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/anonymous-access). The default role enables users to access the authenticate endpoint, change their own passwords, and get information about themselves.
There is also a set of built-in roles you can explicitly assign to users. These roles have a fixed set of privileges and cannot be updated.
When you assign a user multiple roles, the user receives a union of the roles’ privileges.
If the built-in roles do not address your use case, then you can create additional [custom roles](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/defining-roles).

## Available roles

<definitions>
  <definition term="apm_system">
    Grants access necessary for the APM system user to send system-level data (such as monitoring) to Elasticsearch.
  </definition>
  <definition term="beats_admin">
    Grants access to the `.management-beats` index, which contains configuration information for the Beats.
  </definition>
  <definition term="beats_system">
    Grants access necessary for the Beats system user to send system-level data (such as monitoring) to Elasticsearch.
    <note>
      - This role should not be assigned to users as the granted permissions may change between releases.
      - This role does not provide access to the beats indices and is not suitable for writing beats output to Elasticsearch.
    </note>
  </definition>
  <definition term="editor">
    Grants full access to all features in Kibana (including Solutions) and read-only access to data indices.
    <note>
      - This role provides read access to any index that is not prefixed with a dot.
      - This role automatically grants full access to new Kibana features as soon as they are released.
      - Some Kibana features may also require creation or write access to data indices. Machine learning data frame analytics jobs is an example. For such features those privileges must be defined in a separate role.
    </note>
  </definition>
  <definition term="enrich_user">
    Grants access to manage **all** enrich indices (`.enrich-*`) and **all** operations on ingest pipelines.
  </definition>
  <definition term="inference_admin">
    Provides all of the privileges of the `inference_user` role and the full use of the Inference APIs. Grants the `manage_inference` cluster privilege.
  </definition>
  <definition term="inference_user">
    Provides the minimum privileges required to view inference configurations and perform inference. Grants the `monintor_inference` cluster privilege.
  </definition>
  <definition term="ingest_admin">
    Grants access to manage **all** index templates and **all** ingest pipeline configurations.
    <note>
      This role does **not** provide the ability to create indices; those privileges must be defined in a separate role.
    </note>
  </definition>
  <definition term="kibana_dashboard_only_user Elastic Stack: Deprecated">
    This role is deprecated. Use [Kibana feature privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges#kibana-feature-privileges) instead. Grants read-only access to the Kibana Dashboard in every [space in Kibana](https://www.elastic.co/docs/deploy-manage/manage-spaces). This role does not have access to editing tools in Kibana.
  </definition>
  <definition term="kibana_system">
    Grants access necessary for the Kibana system user to read from and write to the Kibana indices, manage index templates and tokens, and check the availability of the Elasticsearch cluster. It also permits activating, searching, and retrieving user profiles, as well as updating user profile data for the `kibana-*` namespace. This role grants read access to the `.monitoring-*` indices and read and write access to the `.reporting-*` indices. For more information, see [Configuring Security in Kibana](https://www.elastic.co/docs/deploy-manage/security/secure-your-cluster-deployment).
    <note>
      This role should not be assigned to users as the granted permissions may change between releases.
    </note>
  </definition>
  <definition term="kibana_admin">
    Grants access to all Kibana features in all spaces. For more information on Kibana authorization, see [Kibana authorization](https://www.elastic.co/docs/reference/elasticsearch/roles).
  </definition>
  <definition term="kibana_user Elastic Stack: Deprecated">
    This role is deprecated. Use the [`kibana_admin`](#built-in-roles-kibana-admin) role instead. Grants access to all features in Kibana.
    For more information on Kibana authorization, see [Kibana authorization](https://www.elastic.co/docs/reference/elasticsearch/roles).
  </definition>
  <definition term="logstash_admin">
    Grants access to the `.logstash*` indices for managing configurations, and grants necessary access for logstash-specific APIs exposed by the logstash x-pack plugin.
  </definition>
  <definition term="logstash_system">
    Grants access necessary for the Logstash system user to send system-level data (such as monitoring) to Elasticsearch. For more information, see [Configuring Security in Logstash](https://www.elastic.co/docs/reference/logstash/secure-connection).
    <note>
      - This role should not be assigned to users as the granted permissions may change between releases.
      - This role does not provide access to the logstash indices and is not suitable for use within a Logstash pipeline.
    </note>
  </definition>
  <definition term="machine_learning_admin">
    Provides all of the privileges of the `machine_learning_user` role plus the full use of the machine learning APIs. Grants `manage_ml` cluster privileges, read access to `.ml-anomalies*`, `.ml-notifications*`, `.ml-state*`, `.ml-meta*` indices and write access to `.ml-annotations*` indices. Machine learning administrators also need index privileges for source and destination indices and roles that grant access to Kibana. See [Machine learning security privileges](https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning#setup-privileges).
  </definition>
  <definition term="machine_learning_user">
    Grants the minimum privileges required to view machine learning configuration, status, and work with results. This role grants `monitor_ml` cluster privileges, read access to the `.ml-notifications` and `.ml-anomalies*` indices (which store machine learning results), and write access to `.ml-annotations*` indices. Machine learning users also need index privileges for source and destination indices and roles that grant access to Kibana. See [Machine learning security privileges](https://www.elastic.co/docs/explore-analyze/machine-learning/setting-up-machine-learning#setup-privileges).
  </definition>
  <definition term="monitoring_user">
    Grants the minimum privileges required for any user of X-Pack monitoring other than those required to use Kibana. This role grants access to the monitoring indices and grants privileges necessary for reading basic cluster information. This role also includes all [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) for the Elastic Stack monitoring features. Monitoring users should also be assigned the `kibana_admin` role, or another role with [access to the Kibana instance](https://www.elastic.co/docs/reference/elasticsearch/roles).
  </definition>
  <definition term="remote_monitoring_agent">
    Grants the minimum privileges required to write data into the monitoring indices (`.monitoring-*`). This role also has the privileges necessary to create Metricbeat indices (`metricbeat-*`) and write data into them.
  </definition>
  <definition term="remote_monitoring_collector">
    Grants the minimum privileges required to collect monitoring data for the Elastic Stack.
  </definition>
  <definition term="reporting_user Elastic Stack: Deprecated since 9.0">
    This role is deprecated. Use [Kibana feature privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges#kibana-feature-privileges) instead.
    Grants the necessary privileges required to use reporting features in Kibana, including generating and downloading reports. This role implicitly grants access to all Kibana reporting features, with each user having access only to their own reports. Note that reporting users should also be assigned additional roles that grant read access to the [indices](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/role-structure#roles-indices-priv) that will be used to generate reports.
  </definition>
  <definition term="rollup_admin">
    Grants `manage_rollup` cluster privileges, which enable you to manage and execute all rollup actions.
  </definition>
  <definition term="rollup_user">
    Grants `monitor_rollup` cluster privileges, which enable you to perform read-only operations related to rollups.
  </definition>
  <definition term="snapshot_user">
    Grants the necessary privileges to create snapshots of **all** the indices and to view their metadata. This role enables users to view the configuration of existing snapshot repositories and snapshot details. It does not grant authority to remove or add repositories or to restore snapshots. It also does not enable to change index settings or to read or update data stream or index data.
  </definition>
  <definition term="superuser">
    Grants full access to cluster management and data indices. This role also grants direct read-only access to restricted indices like `.security`. A user with the `superuser` role can [impersonate](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/submitting-requests-on-behalf-of-other-users) any other user in the system.
    On Elastic Cloud, all standard users, including those with the `superuser` role are restricted from performing [operator-only](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/operator-only-functionality) actions.
    <important>
      This role can manage security and create roles with unlimited privileges. Take extra care when assigning it to a user.
    </important>
  </definition>
  <definition term="transform_admin">
    Grants `manage_transform` cluster privileges, which enable you to manage transforms. This role also includes all [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) for the machine learning features.
  </definition>
  <definition term="transform_user">
    Grants `monitor_transform` cluster privileges, which enable you to perform read-only operations related to transforms. This role also includes all [Kibana privileges](https://www.elastic.co/docs/deploy-manage/users-roles/cluster-or-deployment-auth/kibana-privileges) for the machine learning features.
  </definition>
  <definition term="transport_client">
    Grants the privileges required to access the cluster through the Java Transport Client. The Java Transport Client fetches information about the nodes in the cluster using the *Node Liveness API* and the *Cluster State API* (when sniffing is enabled). Assign your users this role if they use the Transport Client.
    <note>
      Using the Transport Client effectively means the users are granted access to the cluster state. This means users can view the metadata over all indices, index templates, mappings, node and basically everything about the cluster. However, this role does not grant permission to view the data in all indices.
    </note>
  </definition>
  <definition term="viewer">
    Grants read-only access to all features in Kibana (including Solutions) and to data indices.
    <note>
      - This role provides read access to any index that is not prefixed with a dot.
      - This role automatically grants read-only access to new Kibana features as soon as they are available.
    </note>
  </definition>
  <definition term="watcher_admin">
    Allows users to create and execute all Watcher actions. Grants read access to the `.watches` index. Also grants read access to the watch history and the triggered watches index.
  </definition>
  <definition term="watcher_user">
    Grants read access to the `.watches` index, the get watch action and the watcher stats.
  </definition>
</definitions>