﻿---
title: Update cross-cluster API key API examples
description: The update cross-cluster API key API updates the attributes of an existing cross-cluster API key, which is used for API key based remote cluster access...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/update-cc-api-key-examples
products:
  - Elasticsearch
applies_to:
  - Elastic Stack: Generally available
---

# Update cross-cluster API key API examples
The [update cross-cluster API key API](https://www.elastic.co/docs/api/doc/elasticsearch/v9/operation/operation-security-update-cross-cluster-api-key) updates the attributes of an existing cross-cluster API key, which is used for API key based remote cluster access. This page shows you examples of using this API.

## Create a cross-cluster API key

If you create a cross-cluster API key as follows:
```json

{
  "name": "my-cross-cluster-api-key",
  "access": {
    "search": [
      {
        "names": ["logs*"]
      }
    ]
  },
  "metadata": {
    "application": "search"
  }
}
```

A successful call returns a JSON structure that provides API key information. For example:
```json
{
  "id": "VuaCfGcBCdbkQm-e5aOx",
  "name": "my-cross-cluster-api-key",
  "api_key": "ui2lp2axTNmsyakw9tvNnw",
  "encoded": "VnVhQ2ZHY0JDZGJrUW0tZTVhT3g6dWkybHAyYXhUTm1zeWFrdzl0dk5udw=="
}
```


## Inspect the API key

To retrieve key information about the API key, including the exact role descriptor, use the [Get API key API](https://www.elastic.co/docs/api/doc/elasticsearch/v9/operation/operation-security-get-api-key).
```json
```

A successful call returns a JSON structure that contains the information of the API key:
```js
{
  "api_keys": [
    {
      "id": "VuaCfGcBCdbkQm-e5aOx",
      "name": "my-cross-cluster-api-key",
      "type": "cross_cluster",
      "creation": 1548550550158,
      "expiration": null,
      "invalidated": false,
      "username": "myuser",
      "realm": "native1",
      "metadata": {
        "application": "search"
      },
      "role_descriptors": {
        "cross_cluster": {  
          "cluster": [
              "cross_cluster_search"
          ],
          "indices": [
            {
              "names": [
                "logs*"
              ],
              "privileges": [
                "read", "read_cross_cluster", "view_index_metadata"
              ],
              "allow_restricted_indices": false
            }
          ],
          "applications": [ ],
          "run_as": [ ],
          "metadata": { },
          "transient_metadata": {
            "enabled": true
          }
        }
      },
      "access": {  
        "search": [
          {
            "names": [
              "logs*"
            ],
            "allow_restricted_indices": false
          }
        ]
      }
    }
  ]
}
```


## Update access permissions and metadata

The following example updates the API key created above, assigning it new access scope and metadata:
```json

{
  "access": {
    "replication": [
      {
        "names": ["archive"]
      }
    ]
  },
  "metadata": {
    "application": "replication"
  }
}
```

A successful call returns a JSON structure indicating that the API key was updated:
```json
{
  "updated": true
}
```

The API key's permissions after the update can be inspected again with the [Get API key API](https://www.elastic.co/docs/api/doc/elasticsearch/v9/operation/operation-security-get-api-key) and it will be:
```js
{
  "api_keys": [
    {
      "id": "VuaCfGcBCdbkQm-e5aOx",
      "name": "my-cross-cluster-api-key",
      "type": "cross_cluster",
      "creation": 1548550550158,
      "expiration": null,
      "invalidated": false,
      "username": "myuser",
      "realm": "native1",
      "metadata": {
        "application": "replication"
      },
      "role_descriptors": {
        "cross_cluster": {  
          "cluster": [
              "cross_cluster_replication"
          ],
          "indices": [
            {
              "names": [
                "archive*"
              ],
              "privileges": [
                "cross_cluster_replication", "cross_cluster_replication_internal"
              ],
              "allow_restricted_indices": false
            }
          ],
          "applications": [ ],
          "run_as": [ ],
          "metadata": { },
          "transient_metadata": {
            "enabled": true
          }
        }
      },
      "access": {  
        "replication": [
          {
            "names": [
              "archive*"
            ],
            "allow_restricted_indices": false
          }
        ]
      }
    }
  ]
}
```