﻿---
title: Standard retriever
description: A standard retriever returns top documents from a traditional query. When a retriever tree contains a compound retriever (a retriever with two or more...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/standard-retriever
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Standard retriever
A standard retriever returns top documents from a traditional [query](https://www.elastic.co/docs/reference/query-languages/querydsl).

### Parameters:

<definitions>
  <definition term="query">
    (Optional, [query object](https://www.elastic.co/docs/reference/query-languages/querydsl))
    Defines a query to retrieve a set of top documents.
  </definition>
  <definition term="filter">
    (Optional, [query object or list of query objects](https://www.elastic.co/docs/reference/query-languages/querydsl))
    Applies a [boolean query filter](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-bool-query) to this retriever, where all documents must match this query but do not contribute to the score.
  </definition>
  <definition term="search_after">
    (Optional, [search after object](/docs/reference/elasticsearch/rest-apis/paginate-search-results#search-after))
    Defines a search after object parameter used for pagination.
  </definition>
  <definition term="terminate_after">
    (Optional, integer) Maximum number of documents to collect for each shard. If a query reaches this limit, Elasticsearch terminates the query early. Elasticsearch collects documents before sorting.
    <important>
      Use with caution. Elasticsearch applies this parameter to each shard handling the request. When possible, let Elasticsearch perform early termination automatically. Avoid specifying this parameter for requests that target data streams with backing indices across multiple data tiers.
    </important>
  </definition>
  <definition term="sort">
    (Optional, [sort object](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/sort-search-results)) A sort object that specifies the order of matching documents.
  </definition>
  <definition term="min_score">
    (Optional, `float`)
    Minimum [`_score`](/docs/reference/query-languages/query-dsl/query-filter-context#relevance-scores) for matching documents. Documents with a lower `_score` are not included in the top documents.
  </definition>
  <definition term="collapse">
    (Optional, [collapse object](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/collapse-search-results))
    Collapses the top documents by a specified key into a single top document per key.
  </definition>
</definitions>


## Restrictions

When a retriever tree contains a compound retriever (a retriever with two or more child retrievers) the [search after](/docs/reference/elasticsearch/rest-apis/paginate-search-results#search-after) parameter is not supported.

## Example

```json

{
  "retriever": { <1>
    "standard": { <2>
      "query": { <3>
        "bool": { <4>
          "should": [ <5>
            {
              "match": { <6>
                "region": "Austria"
              }
            }
          ],
          "filter": [ <7>
            {
              "term": { <8>
                "year": "2019" <9>
              }
            }
          ]
        }
      }
    }
  }
}
```