﻿---
title: Query rules retriever
description: The rule retriever enables fine-grained control over search results by applying contextual query rules to pin or exclude documents for specific queries...
url: https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rule-retriever
products:
  - Elasticsearch
applies_to:
  - Elastic Cloud Serverless: Generally available
  - Elastic Stack: Generally available
---

# Query rules retriever
The `rule` retriever enables fine-grained control over search results by applying contextual [query rules](/docs/reference/elasticsearch/rest-apis/searching-with-query-rules#query-rules) to pin or exclude documents for specific queries. This retriever has similar functionality to the [rule query](https://www.elastic.co/docs/reference/query-languages/query-dsl/query-dsl-rule-query), but works out of the box with other retrievers.

## Prerequisites

To use the `rule` retriever you must first create one or more query rulesets using the [query rules management APIs](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-query_rules).

## Parameters

<definitions>
  <definition term="retriever">
    (Required, `retriever`)
    The child retriever that returns the results to apply query rules on top of. This can be a standalone retriever such as the [standard](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/standard-retriever) or [knn](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/knn-retriever) retriever, or it can be a compound retriever.
  </definition>
  <definition term="ruleset_ids">
    (Required, `array`)
    An array of one or more unique [query ruleset](https://www.elastic.co/docs/api/doc/elasticsearch/group/endpoint-query_rules) IDs with query-based rules to match and apply as applicable. Rulesets and their associated rules are evaluated in the order in which they are specified in the query and ruleset. The maximum number of rulesets to specify is 10.
  </definition>
  <definition term="match_criteria">
    (Required, `object`)
    Defines the match criteria to apply to rules in the given query ruleset(s). Match criteria should match the keys defined in the `criteria.metadata` field of the rule.
  </definition>
  <definition term="rank_window_size">
    (Optional, `int`)
    The number of top documents to return from the `rule` retriever. Defaults to `10`.
  </definition>
</definitions>


## Example: Rule retriever

This example shows the rule retriever executed without any additional retrievers. It runs the query defined by the `retriever` and applies the rules from `my-ruleset` on top of the returned results.
```json

{
  "retriever": {
    "rule": {
      "match_criteria": {
        "query_string": "harry potter"
      },
      "ruleset_ids": [
        "my-ruleset"
      ],
      "retriever": {
        "standard": {
          "query": {
            "query_string": {
              "query": "harry potter"
            }
          }
        }
      }
    }
  }
}
```


## Example: Rule retriever combined with RRF

This example shows how to combine the `rule` retriever with other rerank retrievers such as [rrf](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/rrf-retriever) or [text_similarity_reranker](https://www.elastic.co/docs/reference/elasticsearch/rest-apis/retrievers/text-similarity-reranker-retriever).
<warning>
  The `rule` retriever will apply rules to any documents returned from its defined `retriever` or any of its sub-retrievers. This means that for the best results, the `rule` retriever should be the outermost defined retriever. Nesting a `rule` retriever as a sub-retriever under a reranker such as `rrf` or `text_similarity_reranker` may not produce the expected results.
</warning>

```json

{
  "retriever": {
    "rule": { <1>
      "match_criteria": {
        "query_string": "harry potter"
      },
      "ruleset_ids": [
        "my-ruleset"
      ],
      "retriever": {
        "rrf": { <2>
          "retrievers": [
            {
              "standard": {
                "query": {
                  "query_string": {
                    "query": "sorcerer's stone"
                  }
                }
              }
            },
            {
              "standard": {
                "query": {
                  "query_string": {
                    "query": "chamber of secrets"
                  }
                }
              }
            }
          ]
        }
      }
    }
  }
}
```